% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/student.R
\name{estimate_group_cates}
\alias{estimate_group_cates}
\title{Subgroup CATE estimation.}
\usage{
estimate_group_cates(fit, X, Y, Z)
}
\arguments{
\item{fit}{Fitted subgroup model used to determine subgroup membership of
individuals. Typically, this is a \code{party} or \code{rpart} object, but any model
object that can be used to determine subgroup membership via
\code{predict(fit, x, type = 'node')} can be used. If
\code{predict(fit, x, type = 'node')} returns an error, then subgroups are
determined based upon the unique values of \code{predict(fit, x)}.}

\item{X}{A tibble, data.frame, or matrix of covariates.}

\item{Y}{A vector of outcomes.}

\item{Z}{A vector of treatments.}
}
\value{
Estimated subgroup average treatment effects tibble with the following columns:
\item{leaf_id}{Leaf node identifier.}
\item{subgroup}{String representation of the subgroup.}
\item{estimate}{Estimated conditional average treatment effect for the subgroup.}
\item{variance}{Asymptotic variance of the estimated conditional average treatment effect.}
\item{.var1}{Sample variance for treated observations in the subgroup.}
\item{.var0}{Sample variance for control observations in the subgroup.}
\item{.n1}{Number of treated observations in the subgroup.}
\item{.n0}{Number of control observations in the subgroup.}
\item{.sample_idxs}{Indices of (holdout) observations in the subgroup.}
}
\description{
This function estimates the conditional average treatment effect for each
subgroup given by the fitted decision tree. The conditional average
treatment effect is estimated as the difference in the average outcome
between treated and control units that fall within each subgroup (i.e.,
each leaf node in the decision tree).
}
\examples{
\donttest{
n <- 50
p <- 3
X <- matrix(rnorm(n * p), nrow = n, ncol = p)
Z <- rbinom(n, 1, 0.5)
Y <- 2 * Z * (X[, 1] > 0) + X[, 2] + rnorm(n, 0.1)

# causal distillation tree output
out <- causalDT(X, Y, Z)
# compute subgroup CATEs manually
group_cates <- estimate_group_cates(
  out$student_fit$fit,
  X = X[out$holdout_idxs, , drop = FALSE],
  Y = Y[out$holdout_idxs],
  Z = Z[out$holdout_idxs]
)
all.equal(out$estimate, group_cates)
}

}
