% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/censoredaidsLoglike.R
\name{censoredaidsLoglike}
\alias{censoredaidsLoglike}
\title{Calculates the truncated (censored) log-likehood function of a share system of equations of a AI or QUAI demand system.}
\usage{
censoredaidsLoglike(
  Shares = matrix(),
  Prices = matrix(),
  Budget = matrix(),
  ShareNames = NULL,
  Demographics = matrix(),
  DemographicNames = NULL,
  Params = matrix(),
  quaids = FALSE
)
}
\arguments{
\item{Shares}{A matrix of shares with (nxm) dimensions where n is the number of observations and m the number of shares.}

\item{Prices}{A matrix of logged prices with (nxm) dimensions where n is the number of observations and m the number of shares.}

\item{Budget}{A matrix of logged total expenditure/budget with (nx1) dimensions where n is the number of observations.}

\item{ShareNames}{A vector of strings containing the share names with (mx1) dimensions where m is the number of shares.}

\item{Demographics}{A matrix of demographic variables with (nxt) dimensions where n is the number of observations and t the number of demographic variables.}

\item{DemographicNames}{A vector of strings containing the demographic names with (tx1) dimensions where t is the number of demographic variables.}

\item{Params}{A vector containing the parameters alpha, beta, gamma, and theta and lambda if elected.}

\item{quaids}{Logical. Should quadratic form be used instead?}
}
\value{
A numeric vector for individual loglikehood contributions with dimensions (nx1) where n is the number of observations.
}
\description{
Calculates the truncated (censored) log-likehood function of a share system of equations of a AI or QUAI demand system.
}
\examples{

\dontrun{
testing_data <- censoredAIDS::MexicanHH_foodConsumption

# Organizing the data for comfort
s1 <- testing_data$s1
s2 <- testing_data$s2
s3 <- testing_data$s3
s4 <- testing_data$s4
s5 <- testing_data$s5
s6 <- testing_data$s6

lnp1 <- testing_data$lnp1
lnp2 <- testing_data$lnp2
lnp3 <- testing_data$lnp3
lnp4 <- testing_data$lnp4
lnp5 <- testing_data$lnp5
lnp6 <- testing_data$lnp6

age <- testing_data$age
size <- testing_data$size
sex <- testing_data$sex
educ <- testing_data$educ

# Alpha
b0 <- rep(0, 5)

# Beta
b0 <- c(b0, rep(0.003, 5))

# Gamma
b0 <- c(b0,0.01,0,0.01,0,0, 0.01,0,0,0,0.01,0,0,0,0,0.01)

# Demos
b0 <- c(b0,rep(0.002, 20))

# Sigma
b0 <- c(b0,1,0,1,0,0,1,0,0,0,1,0,0,0,0,1)

  f <- censoredaidsLoglike(
Params = b0,
Shares = matrix(c(s1, s2, s3, s4, s5, s6), ncol = 6),
Prices = matrix(c(lnp1, lnp2, lnp3, lnp4, lnp5, lnp6), ncol = 6),
Budget = matrix(testing_data$lnw),
Demographics = matrix(c(age, size, educ, sex), ncol = 4),
quaids = FALSE
)
}



}
