% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfbd_games.R
\name{cfbd_game_box_advanced}
\alias{cfbd_game_box_advanced}
\title{\strong{Get game advanced box score information.}}
\usage{
cfbd_game_box_advanced(game_id, long = FALSE)
}
\arguments{
\item{game_id}{(\emph{Integer} required): Game ID filter for querying a single game
Can be found using the \code{\link[=cfbd_game_info]{cfbd_game_info()}} function}

\item{long}{(\emph{Logical} default \code{FALSE}): Return the data in a long format.}
}
\value{
\code{\link[=cfbd_game_box_advanced]{cfbd_game_box_advanced()}} - A data frame with 2 rows and 69 variables:
\describe{
\item{\code{team}: character.}{Team name.}
\item{\code{plays}: double.}{Number of plays.}
\item{\code{ppa_overall_total}: double.}{Predicted points added (PPA) overall total.}
\item{\code{ppa_overall_quarter1}: double.}{Predicted points added (PPA) overall Q1.}
\item{\code{ppa_overall_quarter2}: double.}{Predicted points added (PPA) overall Q2.}
\item{\code{ppa_overall_quarter3}: double.}{Predicted points added (PPA) overall Q3.}
\item{\code{ppa_overall_quarter4}: double.}{Predicted points added (PPA) overall Q4.}
\item{\code{ppa_passing_total}: double.}{Passing predicted points added (PPA) total.}
\item{\code{ppa_passing_quarter1}: double.}{Passing predicted points added (PPA) Q1.}
\item{\code{ppa_passing_quarter2}: double.}{Passing predicted points added (PPA) Q2.}
\item{\code{ppa_passing_quarter3}: double.}{Passing predicted points added (PPA) Q3.}
\item{\code{ppa_passing_quarter4}: double.}{Passing predicted points added (PPA) Q4.}
\item{\code{ppa_rushing_total}: double.}{Rushing predicted points added (PPA) total.}
\item{\code{ppa_rushing_quarter1}: double.}{Rushing predicted points added (PPA) Q1.}
\item{\code{ppa_rushing_quarter2}: double.}{Rushing predicted points added (PPA) Q2.}
\item{\code{ppa_rushing_quarter3}: double.}{Rushing predicted points added (PPA) Q3.}
\item{\code{ppa_rushing_quarter4}: double.}{Rushing predicted points added (PPA) Q4.}
\item{\code{cumulative_ppa_plays}: double.}{Cumulative predicted points added (PPA) added total.}
\item{\code{cumulative_ppa_overall_total}: double.}{Cumulative predicted points added (PPA) total.}
\item{\code{cumulative_ppa_overall_quarter1}: double.}{Cumulative predicted points added (PPA) Q1.}
\item{\code{cumulative_ppa_overall_quarter2}: double.}{Cumulative predicted points added (PPA) Q2.}
\item{\code{cumulative_ppa_overall_quarter3}: double.}{Cumulative predicted points added (PPA) Q3.}
\item{\code{cumulative_ppa_overall_quarter4}: double.}{Cumulative predicted points added (PPA) Q4.}
\item{\code{cumulative_ppa_passing_total}: double.}{Cumulative passing predicted points added (PPA) total.}
\item{\code{cumulative_ppa_passing_quarter1}: double.}{Cumulative passing predicted points added (PPA) Q1.}
\item{\code{cumulative_ppa_passing_quarter2}: double.}{Cumulative passing predicted points added (PPA) Q2.}
\item{\code{cumulative_ppa_passing_quarter3}: double.}{Cumulative passing predicted points added (PPA) Q3.}
\item{\code{cumulative_ppa_passing_quarter4}: double.}{Cumulative passing predicted points added (PPA) Q4.}
\item{\code{cumulative_ppa_rushing_total}: double.}{Cumulative rushing predicted points added (PPA) total.}
\item{\code{cumulative_ppa_rushing_quarter1}: double.}{Cumulative rushing predicted points added (PPA) Q1.}
\item{\code{cumulative_ppa_rushing_quarter2}: double.}{Cumulative rushing predicted points added (PPA) Q2.}
\item{\code{cumulative_ppa_rushing_quarter3}: double.}{Cumulative rushing predicted points added (PPA) Q3.}
\item{\code{cumulative_ppa_rushing_quarter4}: double.}{Cumulative rushing predicted points added (PPA) Q4.}
\item{\code{success_rates_overall_total}: double.}{Success rates overall total.}
\item{\code{success_rates_overall_quarter1}: double.}{Success rates overall Q1.}
\item{\code{success_rates_overall_quarter2}: double.}{Success rates overall Q2.}
\item{\code{success_rates_overall_quarter3}: double.}{Success rates overall Q3.}
\item{\code{success_rates_overall_quarter4}: double.}{Success rates overall Q4.}
\item{\code{success_rates_standard_downs_total}: double.}{Success rates standard downs total.}
\item{\code{success_rates_standard_downs_quarter1}: double.}{Success rates standard downs Q1.}
\item{\code{success_rates_standard_downs_quarter2}: double.}{Success rates standard downs Q2.}
\item{\code{success_rates_standard_downs_quarter3}: double.}{Success rates standard downs Q3.}
\item{\code{success_rates_standard_downs_quarter4}: double.}{Success rates standard downs Q4.}
\item{\code{success_rates_passing_downs_total}: double.}{Success rates passing downs total.}
\item{\code{success_rates_passing_downs_quarter1}: double.}{Success rates passing downs Q1.}
\item{\code{success_rates_passing_downs_quarter2}: double.}{Success rates passing downs Q2.}
\item{\code{success_rates_passing_downs_quarter3}: double.}{Success rates passing downs Q3.}
\item{\code{success_rates_passing_downs_quarter4}: double.}{Success rates passing downs Q4.}
\item{\code{explosiveness_overall_total}: double.}{Explosiveness rates overall total.}
\item{\code{explosiveness_overall_quarter1}: double.}{Explosiveness rates overall Q1.}
\item{\code{explosiveness_overall_quarter2}: double.}{Explosiveness rates overall Q2.}
\item{\code{explosiveness_overall_quarter3}: double.}{Explosiveness rates overall Q3.}
\item{\code{explosiveness_overall_quarter4}: double.}{Explosiveness rates overall Q4.}
\item{\code{rushing_power_success}: double.}{Rushing power success rate.}
\item{\code{rushing_stuff_rate}: double.}{Rushing stuff rate.}
\item{\code{rushing_line_yds}: double.}{Rushing offensive line yards.}
\item{\code{rushing_line_yds_avg}: double.}{Rushing line yards average.}
\item{\code{rushing_second_lvl_yds}: double.}{Rushing second-level yards.}
\item{\code{rushing_second_lvl_yds_avg}: double.}{Average second level yards per rush.}
\item{\code{rushing_open_field_yds}: double.}{Rushing open field yards.}
\item{\code{rushing_open_field_yds_avg}: double.}{Average rushing open field yards average.}
\item{\code{havoc_total}: double.}{Total havoc rate.}
\item{\code{havoc_front_seven}: double.}{Front-7 players havoc rate.}
\item{\code{havoc_db}: double.}{Defensive back players havoc rate.}
\item{\code{scoring_opps_opportunities}: double.}{Number of scoring opportunities.}
\item{\code{scoring_opps_points}: double.}{Points on scoring opportunity drives.}
\item{\code{scoring_opps_pts_per_opp}: double.}{Points per scoring opportunity drives.}
\item{\code{field_pos_avg_start}: double.}{Average starting field position.}
\item{\code{field_pos_avg_starting_predicted_pts}: double.}{Average starting predicted points (PP) for the average starting field position.}
}
}
\description{
\strong{Get game advanced box score information.}
}
\examples{
\donttest{
  try(cfbd_game_box_advanced(game_id = 401114233))
}

}
\seealso{
Other CFBD Games: 
\code{\link{cfbd_calendar}()},
\code{\link{cfbd_game_info}()},
\code{\link{cfbd_game_media}()},
\code{\link{cfbd_game_player_stats}()},
\code{\link{cfbd_game_records}()},
\code{\link{cfbd_game_team_stats}()},
\code{\link{cfbd_game_weather}()},
\code{\link{cfbd_live_scoreboard}()}
}
\concept{CFBD Games}
\keyword{Advanced}
\keyword{Box}
\keyword{Game}
\keyword{Score}
