% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfbd_play.R
\name{cfbd_live_plays}
\alias{cfbd_live_plays}
\title{\strong{Get live college football play-by-play data.}}
\usage{
cfbd_live_plays(game_id)
}
\arguments{
\item{game_id}{(\emph{Integer} Required): Game ID filter for querying a single game
Can be found using the \code{\link[=cfbd_game_info]{cfbd_game_info()}} function}
}
\value{
\code{\link[=cfbd_live_plays]{cfbd_live_plays()}} - A data frame with 94 columns:\tabular{ll}{
   col_name \tab types \cr
   game_id \tab integer \cr
   home_team_id \tab integer \cr
   home_team \tab character \cr
   away_team_id \tab integer \cr
   away_team \tab character \cr
   play_id \tab character \cr
   home_score \tab integer \cr
   away_score \tab integer \cr
   period \tab integer \cr
   clock \tab character \cr
   wall_clock \tab character \cr
   offense_team_id \tab integer \cr
   offense_team \tab character \cr
   down \tab integer \cr
   distance \tab integer \cr
   yards_to_goal \tab integer \cr
   yards_gained \tab integer \cr
   play_type_id \tab integer \cr
   play_type \tab character \cr
   ppa \tab numeric \cr
   garbage_time \tab logical \cr
   success \tab logical \cr
   rush_pass \tab character \cr
   down_type \tab character \cr
   play_text \tab character \cr
   drive_id \tab character \cr
   drive_offense_id \tab integer \cr
   drive_offense_team \tab character \cr
   drive_defense_id \tab integer \cr
   drive_defense_team \tab character \cr
   drive_play_count \tab integer \cr
   drive_yards_gained \tab integer \cr
   drive_start_period \tab integer \cr
   drive_start_clock \tab character \cr
   drive_start_yards_to_goal \tab integer \cr
   drive_end_period \tab integer \cr
   drive_end_clock \tab character \cr
   drive_end_yards_to_goal \tab integer \cr
   drive_duration \tab character \cr
   drive_scoring_opportunity \tab logical \cr
   drive_result \tab character \cr
   drive_points_gained \tab integer \cr
   current_clock \tab character \cr
   current_possession \tab character \cr
   home_line_scores_q1 \tab integer \cr
   home_line_scores_q2 \tab integer \cr
   home_line_scores_q3 \tab integer \cr
   home_line_scores_q4 \tab integer \cr
   home_points \tab integer \cr
   home_drives \tab integer \cr
   home_scoring_opportunities \tab integer \cr
   home_points_per_opportunity \tab numeric \cr
   home_average_start_yard_line \tab numeric \cr
   home_plays \tab integer \cr
   home_line_yards \tab numeric \cr
   home_line_yards_per_rush \tab numeric \cr
   home_second_level_yards \tab integer \cr
   home_second_level_yards_per_rush \tab numeric \cr
   home_open_field_yards \tab integer \cr
   home_open_field_yards_per_rush \tab numeric \cr
   home_ppa_per_play \tab numeric \cr
   home_total_ppa \tab numeric \cr
   home_passing_ppa \tab numeric \cr
   home_ppa_per_pass \tab numeric \cr
   home_rushing_ppa \tab numeric \cr
   home_ppa_per_rush \tab numeric \cr
   home_success_rate \tab numeric \cr
   home_standard_down_success_rate \tab numeric \cr
   home_passing_down_success_rate \tab numeric \cr
   home_explosiveness \tab numeric \cr
   home_deserve_to_win \tab numeric \cr
   away_line_scores_q1 \tab integer \cr
   away_line_scores_q2 \tab integer \cr
   away_line_scores_q3 \tab integer \cr
   away_line_scores_q4 \tab integer \cr
   away_points \tab integer \cr
   away_drives \tab integer \cr
   away_scoring_opportunities \tab integer \cr
   away_points_per_opportunity \tab numeric \cr
   away_average_start_yard_line \tab numeric \cr
   away_plays \tab integer \cr
   away_line_yards \tab numeric \cr
   away_line_yards_per_rush \tab numeric \cr
   away_second_level_yards \tab integer \cr
   away_second_level_yards_per_rush \tab numeric \cr
   away_open_field_yards \tab integer \cr
   away_open_field_yards_per_rush \tab numeric \cr
   away_ppa_per_play \tab numeric \cr
   away_total_ppa \tab numeric \cr
   away_passing_ppa \tab numeric \cr
   away_ppa_per_pass \tab numeric \cr
   away_rushing_ppa \tab numeric \cr
   away_ppa_per_rush \tab numeric \cr
   away_success_rate \tab numeric \cr
   away_standard_down_success_rate \tab numeric \cr
   away_passing_down_success_rate \tab numeric \cr
   away_explosiveness \tab numeric \cr
   away_deserve_to_win \tab numeric \cr
}
}
\description{
\strong{Get live college football play-by-play data.}
}
\examples{
\donttest{
  try(cfbd_live_plays(game_id=401520182))
}
}
\seealso{
Other CFBD PBP: 
\code{\link{cfbd_pbp_data}()},
\code{\link{cfbd_play_stats_player}()},
\code{\link{cfbd_play_stats_types}()},
\code{\link{cfbd_play_types}()},
\code{\link{cfbd_plays}()}
}
\concept{CFBD PBP}
