% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfbd_metrics.R
\name{cfbd_metrics_ppa_players_games}
\alias{cfbd_metrics_ppa_players_games}
\title{\strong{Get player game averages for predicted points added (PPA)}}
\usage{
cfbd_metrics_ppa_players_games(
  year = NULL,
  week = NULL,
  season_type = "both",
  team = NULL,
  position = NULL,
  athlete_id = NULL,
  threshold = NULL,
  excl_garbage_time = FALSE
)
}
\arguments{
\item{year}{(\emph{Integer} required): Year, 4 digit format (\emph{YYYY}).}

\item{week}{(\emph{Integer} optional): Week - values range from 1-15, 1-14 for seasons pre-playoff, i.e. 2013 or earlier. Required if team not provided.}

\item{season_type}{(\emph{String} default both): Season type - regular, postseason, both, allstar, spring_regular, spring_postseason}

\item{team}{(\emph{String} optional): D-I Team. Required if week not provided.}

\item{position}{(\emph{string} optional): Position abbreviation of the player you are searching for.
Position Group  - options include:
\itemize{
\item Offense: QB, RB, FB, TE,  OL, G, OT, C, WR
\item Defense: DB, CB, S, LB,  DE, DT, NT, DL
\item Special Teams: K, P, LS, PK
}}

\item{athlete_id}{(\emph{Integer} optional): Athlete ID filter for querying a single athlete
Can be found using the \code{\link[=cfbd_player_info]{cfbd_player_info()}} function.}

\item{threshold}{(\emph{Integer} optional): Minimum threshold of plays.}

\item{excl_garbage_time}{(\emph{Logical} default FALSE): Select whether to exclude Garbage Time (TRUE or FALSE)}
}
\value{
\code{\link[=cfbd_metrics_ppa_players_games]{cfbd_metrics_ppa_players_games()}} - A data frame with 9 variables:
\describe{
\item{\code{season}: integer.}{Season of the game.}
\item{\code{week}: integer.}{Game week of the season.}
\item{\code{athlete_id}: character.}{Athlete referencing id.}
\item{\code{name}: character.}{Athlete name.}
\item{\code{position}: character.}{Athlete position.}
\item{\code{team}: character.}{Team name.}
\item{\code{opponent}: character.}{Team Opponent name.}
\item{\code{avg_PPA_all}: double.}{Average overall predicted points added (PPA).}
\item{\code{avg_PPA_pass}: double.}{Average passing predicted points added (PPA).}
\item{\code{avg_PPA_rush}: double.}{Average rushing predicted points added (PPA).}
}
}
\description{
\strong{Get player game averages for predicted points added (PPA)}
}
\examples{
\donttest{
  try(cfbd_metrics_ppa_players_games(year = 2019, week = 3, team = "TCU"))
}
}
\seealso{
Other CFBD Metrics: 
\code{\link{cfbd_metrics_fg_ep}()},
\code{\link{cfbd_metrics_ppa_games}()},
\code{\link{cfbd_metrics_ppa_players_season}()},
\code{\link{cfbd_metrics_ppa_predicted}()},
\code{\link{cfbd_metrics_ppa_teams}()},
\code{\link{cfbd_metrics_wepa_players_kicking}()},
\code{\link{cfbd_metrics_wepa_players_passing}()},
\code{\link{cfbd_metrics_wepa_players_rushing}()},
\code{\link{cfbd_metrics_wepa_team_season}()},
\code{\link{cfbd_metrics_wp}()},
\code{\link{cfbd_metrics_wp_pregame}()}
}
\concept{CFBD Metrics}
\keyword{Players}
\keyword{Points}
\keyword{Predicted}
