% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AMOCfunc.R
\name{AMOCpopulation}
\alias{AMOCpopulation}
\title{Random population initialization for AMOC problem}
\usage{
AMOCpopulation(popSize, prange, N, minDist, pchangepoint, mmax, lmax)
}
\arguments{
\item{popSize}{An integer represents the number of individual in each
population for GA (or subpopulation for IslandGA).}

\item{prange}{Default is \code{NULL} for only changepoint detection. If
\code{prange} is specified as a list object, which contains the range of
each model order parameters for order selection (integers). The number of
order parameters must be equal to the length of \code{prange}.}

\item{N}{The length of time series.}

\item{minDist}{The minimum length between two adjacent changepoints.}

\item{pchangepoint}{The probability that a changepoint can occur.}

\item{mmax}{The maximum possible number of changepoints in the data set.}

\item{lmax}{The maximum possible length of the chromosome representation.}
}
\value{
A matrix that contains each individual's chromosome.
}
\description{
Randomly generate the individuals' chromosomes (changepoint configurations)
to construct the first generation population for the at most one changepoint
(AMOC) problem.
}
\details{
Given the possible candidate changepoint location set, each chromosome in the
first generation population can be obtained by randomly sampling one location
from the candidate set. The first element of every chromosome represent the
number of changepoints and the last non-zero element always equal to the
length of time series plus one (N+1).
}
