% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertRscript2Function.R
\name{convertRscript2Function}
\alias{convertRscript2Function}
\title{convertRscript2Function}
\usage{
convertRscript2Function(
  Model = "gpt-4o-mini",
  SelectedCode = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{Model}{The OpenAI GPT model to use for text generation. Default is "gpt-4o-mini".}

\item{SelectedCode}{Logical flag to indicate whether to use selected code in RStudio. Default is TRUE.}

\item{verbose}{A logical value indicating whether to print the result to the console, default is TRUE.}
}
\value{
Inserts the converted function into the RStudio editor if `SelectedCode` is TRUE, otherwise writes to clipboard.
}
\description{
Convert selected R script to an R function using LLM.
}
\details{
Convert Selected R Script to R Function

This function takes a selected portion of an R script and converts it into an R function.
The function uses the OpenAI GPT model for text generation to assist in the conversion.
The function can either take the selected code from the RStudio environment or from the clipboard.
}
\examples{
\dontrun{
# Option 1
# Select some text in RStudio and then run the rstudio addins
# Option 2
# Copy the text into your clipboard then execute
convertRscript2Function(Model = "gpt-4o-mini", SelectedCode = F)
}
}
\author{
Satoshi Kume
}
