% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/choice_preferences.R
\name{choice_preferences}
\alias{choice_preferences}
\alias{generate_choice_preferences}
\title{Define choice preferences}
\usage{
choice_preferences(data_frame, column_decider = colnames(data_frame)[1])

generate_choice_preferences(
  choice_effects,
  choice_parameters = NULL,
  choice_identifiers = generate_choice_identifiers(N = 100)
)
}
\arguments{
\item{data_frame}{[\code{data.frame}]\cr
Contains the deciders' preferences.}

\item{column_decider}{[\code{character(1)} | \code{NULL}]\cr
The column name of \code{data_frame} with the decider identifiers.
If \code{NULL}, decider identifiers are generated.}

\item{choice_effects}{[\code{choice_effects}]\cr
A \code{\link{choice_effects}} object.}

\item{choice_parameters}{[\code{choice_parameters}]\cr
A \code{\link{choice_parameters}} object.}

\item{choice_identifiers}{[\code{choice_identifiers}]\cr
A \code{\link{choice_identifiers}} object.}
}
\value{
An object of class \code{choice_preferences}, which is a \code{data.frame} with the
deciders' preferences. The column names are the names of the effects in the
choice model. The first column contains the decider identifiers.
}
\description{
The \code{choice_preferences} object defines the deciders' preferences in the
choice model.
\itemize{
\item \code{choice_preferences()} constructs a \code{choice_preferences} object.
\item \code{generate_choice_preferences()} samples choice preferences at random.
}
}
\examples{
### generate choice preferences from choice parameters and effects
choice_effects <- choice_effects(
  choice_formula = choice_formula(
    formula = choice ~ price | income | comfort,
    error_term = "probit",
    random_effects = c(
      "price" = "cn",
      "income" = "cn"
    )
  ),
  choice_alternatives = choice_alternatives(J = 3)
)

choice_parameters <- generate_choice_parameters(
  choice_effects = choice_effects
)

ids <- generate_choice_identifiers(N = 4)

(choice_preferences <- generate_choice_preferences(
  choice_parameters = choice_parameters,
  choice_effects = choice_effects,
  choice_identifiers = ids
))

### inspect decider-specific preference vectors
head(choice_preferences)
}
\keyword{model}
