#' A data.frame containing basic demographic information about Japan.  
#'
#' @name df_japan_census
#' @usage data(df_japan_census)
#' @docType data
#' @references Taken from the "Total Population" table from the Statistics
#'   Bureau of Japan website
#' (\url{https://www.stat.go.jp/english/data/nenkan/1431-02.html}) on 12/1/2014.
#' @keywords data
NULL

#' A data.frame containing election results from the 2012 US Presidential
#' election.
#' 
#' @name df_president
#' @usage data(df_president)
#' @docType data
#' @references Taken from the FEC website on 11/21/2014.
#' @keywords data
#' @author Ari Lamstein and Richard Careaga
NULL

#' A data.frame containing demographic statistics for each state plus the
#' District of Columbia.
#'
#' @name df_state_demographics
#' @docType data
#' @references Data comes from the 2013 5-year American Community Survey (ACS).\cr
#'   Data generated by get_state_demographics().
#' @keywords data
#' @usage data(df_state_demographics)
NULL


#' A data.frame containing demographic statistics for each county in the United
#' States.
#'
#' @name df_county_demographics
#' @docType data
#' @references Data comes from the 2013 5-year American Community Survey (ACS).\cr
#'   Data generated by get_county_demographics().
#' @keywords data
#' @usage data(df_county_demographics)
NULL

#' A data.frame containing demographic statistics for each zip code in Rhode
#' Island.
#' 
#' @name df_ri_zip_demographics
#' @docType data
#' @references Data comes from the 2013 5-year American Community Survey (ACS).\cr
#' @keywords data
#' @usage data(df_ri_zip_demographics)
NULL

#' A data.frame containing demographic statistics for each Census Tract in New
#' York State.
#' 
#' @name df_ny_tract_demographics
#' @docType data
#' @references Data comes from the 2013 5-year American Community Survey (ACS).\cr
#'   Data generated by get_tract_demographics(). 
#' @keywords data
#' @usage data(df_ny_tract_demographics)
NULL

#' A data.frame containing population estimates for Countries in 2012.   
#'
#' @name df_country_demographics
#' @docType data
#' @references Data obtained using the ne_countries function from rnaturalearth \cr
#'   \url{https://github.com/ropensci/rnaturalearth},\cr
#'   \url{https://www.naturalearthdata.com/}
#' @keywords data
#' @usage data(df_country_demographics)
NULL

#' An sf containing lower resolution geometry data for US states
#'
#' @name state.map.lores
#' @usage data(state.map.lores)
#' @docType data
#' @references obtained using tigris::states()
NULL



#' An sf containing higher resolution geometry data for US states
#'
#' @name state.map.hires
#' @usage data(state.map.hires)
#' @docType data
#' @references obtained using tigris::states()
NULL

#' An sf containing geometry data for US states with DC enlarged
#'
#' @name state.map.bigdc
#' @usage data(state.map.bigdc)
#' @docType data
NULL

#' An sf containing a hexagonal tile map for US states
#'
#' @name state.map.hex
#' @usage data(state.map.hex)
#' @docType data
#' @references obtained from: \href{https://raw.githubusercontent.com/Z3tt/30DayMapChallenge/master/data/us_states_hexgrid.geojson.json}{Cedric Scherer's Github}
NULL

#' Supported regions for US states
#'
#' @name state.regions
#' @usage data(state.regions)
#' @docType data
NULL

#' An sf containing geometry data for US counties in 2015
#'
#' @name county.map.2015
#' @usage data(county.map.2015)
#' @docType data
#' @references obtained using tigris::counties()
NULL

#' Supported regions for US counties in 2015
#'
#' @name county.regions.2015
#' @usage data(county.regions.2015)
#' @docType data
NULL

#' An sf containing geometry data for US counties in 2024
#'
#' @name county.map.2024
#' @usage data(county.map.2024)
#' @docType data
#' @references obtained using tigris::counties()
NULL

#' Supported regions for US counties in 2024
#'
#' @name county.regions.2024
#' @usage data(county.regions.2024)
#' @docType data
NULL

#' Supported countries along with lookup data in multiple languages
#'
#' @name country.regions
#' @usage data(country.regions)
#' @docType data
NULL

#' An sf containing geometry data for countries of the world
#' 
#' @name country.map
#' @usage data(country.map)
#' @docType data
#' @references Data obtained using the ne_countries function from rnaturalearth; \cr
#'   \url{https://github.com/ropensci/rnaturalearth}, \cr
#'   \url{https://www.naturalearthdata.com/}
NULL

#' An sf containing geometry data for sub-country regions
#' 
#' @name admin1.map
#' @usage data(admin1.map)
#' @docType data
#' @references Data obtained using rnatrualearth
NULL

#' Supported world sub-country regions with lookup data in multiple languages
#' 
#' This dataset contains feature names for world sub-country regions in many
#' languages and formats, and can be used to join your data to the identifiers
#' accepted by the choropleth_admin1() function. For feature names in even more
#' languages, please see rnaturalearth::ne_states().
#' @name admin1.regions
#' @usage data(admin1.regions)
#' @docType data
#' @references Data obtained using rnatrualearth
NULL

#' A dataset that maps zip codes to counties, states, and CBSAs
#' 
#' @name zip_lookup
#' @usage data(zip_lookup)
#' @docType data
#' @references Data obtained from Census Department
NULL
