% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_mdf.R
\name{read_mdf}
\alias{read_mdf}
\title{Read 'Lumex' MDF}
\usage{
read_mdf(
  path,
  format_out = c("matrix", "data.frame", "data.table"),
  data_format = c("wide", "long"),
  read_metadata = TRUE
)
}
\arguments{
\item{path}{The path to a 'Lumex' \code{.mdf} file.}

\item{format_out}{Class of output. Either \code{matrix}, \code{data.frame},
or \code{data.table}.}

\item{data_format}{Whether to return data in \code{wide} or \code{long} format.}

\item{read_metadata}{Whether to read metadata from file.}
}
\value{
A chromatogram in the format specified by the \code{format_out} and
\code{data_format} arguments (retention time x wavelength).
}
\description{
Reads 'Lumex' \code{.mdf} files.
}
\author{
Ethan Bass
}
