% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_chemstation_report.R
\name{read_chemstation_reports}
\alias{read_chemstation_reports}
\title{Read 'Agilent ChemStation' report files.}
\usage{
read_chemstation_reports(
  paths,
  data_format = c("chromatographr", "original"),
  metadata_format = c("chromconverter", "raw")
)
}
\arguments{
\item{paths}{Paths to 'ChemStation' report files.}

\item{data_format}{Format to output data. Either \code{chromatographr} or
\code{chemstation}.}

\item{metadata_format}{Format to output metadata. Either \code{chromconverter} or
\code{raw}.}
}
\value{
A data.frame containing the information from the specified
'ChemStation' report.
}
\description{
Reads 'Agilent ChemStation' reports into R.
}
\seealso{
Other 'Agilent' parsers: 
\code{\link{read_agilent_d}()},
\code{\link{read_agilent_dx}()},
\code{\link{read_chemstation_ch}()},
\code{\link{read_chemstation_csv}()},
\code{\link{read_chemstation_ms}()},
\code{\link{read_chemstation_uv}()}
}
\author{
Ethan Bass
}
\concept{'Agilent' parsers}
