% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_map.R
\name{GetMAP}
\alias{GetMAP}
\title{Get the maximum a posteriori state}
\usage{
GetMAP(x)
}
\arguments{
\item{x}{A collection of unique objects or chains object.}
}
\value{
A list with the adjacency matrix for the map and it's posterior
probability. It is possible for it to return multiple DAGs. The list has
elements;
\itemize{
\item state: List of MAP DAGs.
\item log_p: Numeric vector with the log posterior probability for each state.
\item log_state_score: Numeric vector representing the log score for each state.
\item log_norm_state_score: Numeric vector representing the log of the
normalised score for each state.
}
}
\description{
Get the maximum a posteriori state
}
\examples{
data <- bnlearn::learning.test

dag <- UniformlySampleDAG(colnames(data))
partitioned_nodes <- DAGtoPartition(dag)

scorer <- CreateScorer(
  scorer = BNLearnScorer, 
  data = data
  )

results <- SampleChains(10, partitioned_nodes, PartitionMCMC(), scorer)

# Get the MAP per chain. Can be helpful to compare chains.
GetMAP(results)

# Get MAP across all chains.
results |>
  FlattenChains() |>
  GetMAP()


}
