% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prop_ci.R
\name{ci_prop_wilson_strata}
\alias{ci_prop_wilson_strata}
\title{Stratified Wilson CI}
\usage{
ci_prop_wilson_strata(
  x,
  strata,
  weights = NULL,
  conf.level = 0.95,
  max.iterations = 10L,
  correct = FALSE,
  data = NULL
)
}
\arguments{
\item{x}{(\code{binary}/\code{numeric}/\code{logical})\cr
vector of a binary values, i.e. a logical vector, or numeric with values \code{c(0, 1)}}

\item{strata}{(\code{numeric}) \cr A vector specifying the stratum for each observation. It needs
to be the length of x or a multiple of x if multiple levels of strata are
present. Can also be a column name (or vector of column names NOT quoted)
if a data frame provided in the \code{data} argument.}

\item{weights}{(\code{numeric})\cr weights for each level of the strata. If \code{NULL}, they are
estimated using the iterative algorithm that
minimizes the weighted squared length of the confidence interval.}

\item{conf.level}{(\verb{scalar numeric}) \cr a scalar in (0,1) indicating the confidence level. Default is 0.95}

\item{max.iterations}{(positive \code{integer})\cr maximum number of iterations for the iterative procedure used
to find estimates of optimal weights.}

\item{correct}{(scalar \code{logical})\cr include the continuity correction. For further information, see for example
\code{\link[stats:prop.test]{stats::prop.test()}}.}

\item{data}{(\code{data.frame}) \cr Optional data frame containing the variables specified in \code{x} and \code{by}.}
}
\value{
An object containing the following components:

\item{n}{Number of responses}
\item{N}{Total number}
\item{estimate}{The point estimate of the proportion}
\item{conf.low}{Lower bound of the confidence interval}
\item{conf.high}{Upper bound of the confidence interval}
\item{conf.level}{The confidence level used}
\item{weights}{Weights of each strata, will be the same as the input unless
unspecified, then it will be the dynamically calculated weights.}
\item{method}{Type of method used}
}
\description{
Calculates the stratified Wilson confidence
interval for unequal proportions as described in
Xin YA, Su XG. Stratified Wilson and Newcombe confidence intervals
for multiple binomial proportions. \emph{Statistics in Biopharmaceutical Research}. 2010;2(3).
}
\details{
\deqn{\frac{\hat{p}_j + \frac{z^2_{\alpha/2}}{2n_j} \pm
z_{\alpha/2} \sqrt{\frac{\hat{p}_j(1 - \hat{p}_j)}{n_j} +
\frac{z^2_{\alpha/2}}{4n_j^2}}}{1 + \frac{z^2_{\alpha/2}}{n_j}}}
}
\examples{
# Stratified Wilson confidence interval with unequal probabilities

set.seed(1)
rsp <- sample(c(TRUE, FALSE), 100, TRUE)
strata_data <- data.frame(
  "f1" = sample(c("a", "b"), 100, TRUE),
  "f2" = sample(c("x", "y", "z"), 100, TRUE),
  stringsAsFactors = TRUE
)
strata <- interaction(strata_data)
n_strata <- ncol(table(rsp, strata)) # Number of strata

ci_prop_wilson_strata(
  x = rsp, strata = strata,
  conf.level = 0.90
)

# Not automatic setting of weights
ci_prop_wilson_strata(
  x = rsp, strata = strata,
  weights = rep(1 / n_strata, n_strata),
  conf.level = 0.90
)

}
