% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{usage_list_matching}
\alias{usage_list_matching}
\title{Get usage statistics for a given organization}
\usage{
usage_list_matching(
  org_id = NULL,
  task = NULL,
  start_date = NULL,
  end_date = NULL
)
}
\arguments{
\item{org_id}{integer optional. The ID of the organization to get usage statistics for.}

\item{task}{string optional. The type of matching job contributing to this usage. One of ["IDR", "CDM"].}

\item{start_date}{string optional. The start date of the range to get usage statistics for.}

\item{end_date}{string optional. The end date of the range to get usage statistics for.}
}
\value{
An array containing the following fields:
\item{runId}{integer, The ID of the run which contributed this usage.}
\item{jobId}{integer, The ID of the job which contributed this usage.}
\item{userId}{integer, The ID of the user who contributed this usage.}
\item{organizationId}{integer, The organization of the user who contributed this usage.}
\item{runCreatedAt}{string, When the run was created at.}
\item{runTime}{integer, The duration of the run in seconds.}
\item{numRecords}{integer, The number of records matched by the run.}
\item{task}{string, The type of matching job contributing to this usage. One of ["IDR", "CDM"].}
}
\description{
Get usage statistics for a given organization
}
