% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctperson.R
\name{ctperson}
\alias{ctperson}
\title{Classical test theory person statistics}
\usage{
ctperson(x, administered = NULL, maxscore = NULL)
}
\arguments{
\item{x}{a data frame or matrix of scored data.}

\item{administered}{a logical matrix indicating which items were administered.
The dimensions should be the same as \code{x}. If \code{NULL} all items
are considered administered.}

\item{maxscore}{a numeric value indicating which is the maximum score possible
per item. The minimum score is assumed to be 0. If \code{NULL} the maximum score is assumed to be
derived from the maximum value found in \code{x} or 1 if \code{x} only has 0s.}
}
\value{
A data frame with person statistics.
}
\description{
Calculates persons statistics given a data frame (or matrix) of corrected
data. Including sum scores, number of administered items, number of
answered items, proportion of correct items, and mean score by item.
}
\examples{
# Data preparation
## Scored data
corr <- correct(x = dichodata, key = dichokey, navalue = NA)
## Random administered matrix
set.seed(1919)
admin <- sample(x = 0:1, size = nrow(corr)*ncol(corr), replace = TRUE, prob = c(.05,.95))
admin <- matrix(data = as.logical(admin),nrow = nrow(corr))
head(admin)


# Person statistics with all items administered
ex1 <- ctperson(x = corr)
head(ex1)

# Person statistics with NOT all items administered
ex2 <- ctperson(x = corr, administered = admin)
head(ex2)

}
