% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dichotomize.R
\name{dichotomize}
\alias{dichotomize}
\title{Dichotomize data}
\usage{
dichotomize(x, id = NULL, categories = NULL, NAasNA = TRUE, sortbyItem = FALSE)
}
\arguments{
\item{x}{a data frame or matrix.}

\item{id}{a vector of unique values indicating the ids of the cases.
If \code{NULL}, an id will be created following
\code{id <- 1L:nrow(x)}. Default is \code{NULL}.}

\item{categories}{a vector indicating all possible categories.
If \code{NULL}, this vector will be created with all the non-NA
values present in \code{x}. Default is \code{NULL}.}

\item{NAasNA}{a logical value indicating if NAs should be kept
as NAs. If \code{FALSE}, NAs will be 0s. Default is \code{TRUE}.}

\item{sortbyItem}{a logical value indicating if the resulting data frame
should be order by item names, on the contrary, by ids.
Default is \code{FALSE}.}
}
\value{
A data frame with columns for the ids, the item names and all
the possible item categories, where 1s mean the person answered that category
for that item, and 0s mean the contrary.
}
\description{
Converts a matrix or data frame into a dichotomized data frame.
Where each possible category is assigned a 1 or a 0.
}
\examples{
data(dichodata)

# Dichotomize with all present categories
ex1 <- dichotomize(dichodata, categories = NULL)
head(ex1)

# Dichotomize with fixed set of categories
ex2 <- dichotomize(dichodata, categories = c('A','B','C','D'))
head(ex2)

# Dichotomize with NAs as 0s
ex3 <- dichotomize(dichodata, NAasNA = FALSE)
head(ex3)


}
