% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itemmean.R
\name{itemmean}
\alias{itemmean}
\title{Item mean scores}
\usage{
itemmean(x, wt = NULL)
}
\arguments{
\item{x}{a data frame or matrix of scored data.}

\item{wt}{a vector with total weights. Default is \code{NULL}.}
}
\value{
a data frame.
}
\description{
Calculates the item mean scores.
}
\examples{
# No weights
ex <- correct(x = dichodata, key = dichokey, navalue = NA)
itemmean(ex)


# With weights
set.seed(1919)
wt <- sample(x = 1:4, size = nrow(dichodata), replace = TRUE)
itemmean(ex,wt = wt)

}
