% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pagination.R
\name{clin_auto_page}
\alias{clin_auto_page}
\title{Enable Word Auto-Pagination Using Group Variable}
\usage{
clin_auto_page(x, group_var, when = c("change", "notempty"), drop = FALSE)
}
\arguments{
\item{x}{A clintable object}

\item{group_var}{A string containing a variable name of the input dataset used to
calculate groups}

\item{when}{Character string indicating when to apply padding:
\itemize{
\item \code{"notempty"}: Find allowable break points when the value in \code{group_var}
is not empty.
\item \code{"change"}: Find allowable break points when the value in \code{group_var} changes
from the previous row.
}}

\item{drop}{Keep or drop the `group_var`` variable}
}
\value{
A clintable object
}
\description{
This function uses the applies the functionality \code{flextable::keep_with_next()}
by automatically building the row indices using some grouping variable. Each group
identified by the variable (i.e. when the value of the variable changes) will be set
as a "keep_with_next" group in Word. Using this functionality, Word will attempt not to
break that group across pages, enabling smoother pagination without having to do specific
calculations of page breaks.
}
\examples{

clintable(mtcars) |>
  clin_auto_page("gear")

}
