\name{aims_tardive_dyskinesia}
\alias{aims_tardive_dyskinesia}
\title{
Abnormal Involuntary Movement Scale (AIMS)
}
\description{
Calculates the total score for the first 7 items of the AIMS to screen for Tardive Dyskinesia (TD) in patients receiving neuroleptic therapy. It also provides a diagnostic interpretation based on the Schooler-Kane criteria.
}
\usage{
aims_tardive_dyskinesia(facial, lips, jaw, tongue, upper_ext, lower_ext, trunk)
}
\arguments{
  \item{facial}{
Numeric (0-4). Muscles of Facial Expression (e.g., frowning, grimacing).
}
  \item{lips}{
Numeric (0-4). Lips and Perioral Area (e.g., puckering, smacking).
}
  \item{jaw}{
Numeric (0-4). Jaw (e.g., biting, clenching, chewing).
}
  \item{tongue}{
Numeric (0-4). Tongue (e.g., protrusion, tremor).
}
  \item{upper_ext}{
Numeric (0-4). Upper Extremities (e.g., choreic movements).
}
  \item{lower_ext}{
Numeric (0-4). Lower Extremities (e.g., tapping, stomping).
}
  \item{trunk}{
Numeric (0-4). Neck, Shoulders, and Hips (e.g., rocking, twisting).
}
}
\details{
\strong{Scoring Key:}
0 = None
1 = Minimal (may be extreme normal)
2 = Mild
3 = Moderate
4 = Severe
}
\value{
A list containing:
\item{Total_Score}{Sum of items 1-7.}
\item{Interpretation}{Diagnostic suggestion (Positive if >=3 in 1 area OR >=2 in 2 areas).}
}
\references{
Guy W. ECDEU Assessment Manual for Psychopharmacology. Rockville, MD: US Department of Health, Education, and Welfare Public Health Service Alcohol, Drug Abuse, and Mental Health Administration. 1976.
}
\examples{

# Example 1: Positive for TD
# Moderate Tongue (3) movement, others minimal
aims_tardive_dyskinesia(1, 1, 1, 3, 1, 0, 0)

# Example 2: Negative for TD
# Mild Facial (2) movement only
aims_tardive_dyskinesia(2, 0, 0, 0, 0, 0, 0)
}
