\name{asdas_esr}
\alias{asdas_esr}
\title{
Ankylosing Spondylitis Disease Activity Score with ESR (ASDAS-ESR)
}
\description{
Calculates the ASDAS-ESR score, a composite index to assess disease activity in patients with Ankylosing Spondylitis (AS). It combines patient-reported outcomes (Back Pain, Morning Stiffness, Global Assessment, Peripheral Pain) with the Erythrocyte Sedimentation Rate (ESR).
}
\usage{
asdas_esr(back_pain, duration_morning_stiffness, patient_global,
          peripheral_pain_swelling, esr_mm_hr)
}
\arguments{
  \item{back_pain}{
Numeric (0-10). Severity of back pain (BASDAI Question 2).
}
  \item{duration_morning_stiffness}{
Numeric (0-10). Duration of morning stiffness (BASDAI Question 6).
}
  \item{patient_global}{
Numeric (0-10). Patient global assessment of disease activity.
}
  \item{peripheral_pain_swelling}{
Numeric (0-10). Severity of peripheral pain/swelling (BASDAI Question 3).
}
  \item{esr_mm_hr}{
Numeric. Erythrocyte Sedimentation Rate in mm/hr.
}
}
\value{
A list containing:
\item{ASDAS_ESR_Score}{The calculated score.}
\item{Disease_Activity_State}{Classification (Inactive < 1.3, Moderate < 2.1, High <= 3.5, Very High > 3.5).}
}
\references{
Lukas C, Landewe R, Sieper J, et al. Development of an ASAS-endorsed disease activity score for ankylosing spondylitis (ASDAS). Ann Rheum Dis. 2009;68(1):18-24. doi:10.1136/ard.2008.094870
}
\examples{

# Example 1: High Disease Activity
# Back Pain 6, Stiffness 5, Global 6, Peripheral 4, ESR 25
asdas_esr(6, 5, 6, 4, 25)

# Example 2: Inactive Disease
# All scores 1, ESR 5
asdas_esr(1, 1, 1, 1, 5)
}
