\name{dash_vte_recurrence_score}
\alias{dash_vte_recurrence_score}
\title{
DASH Prediction Score for Recurrent VTE
}
\description{
Calculates the DASH score to predict the risk of recurrent venous thromboembolism (VTE) in patients who have completed at least 3 months of anticoagulation for a first unprovoked VTE. The score helps determine whether indefinite anticoagulation is warranted.
}
\usage{
dash_vte_recurrence_score(d_dimer_abnormal, age, sex, hormone_use_at_onset = 0)
}
\arguments{
  \item{d_dimer_abnormal}{
Numeric (0 or 1). Was the D-dimer level abnormal when measured roughly 1 month after stopping anticoagulation? (1 = Yes, +2 points).
}
  \item{age}{
Numeric. Patient age in years. (<= 50 years adds +1 point).
}
  \item{sex}{
String. Patient sex ("Male" or "Female"). (Male adds +1 point).
}
  \item{hormone_use_at_onset}{
Numeric (0 or 1). For females: Was the initial VTE associated with hormone use (e.g., OCPs, HRT)? (1 = Yes, -2 points). Defaults to 0.
}
}
\value{
A list containing:
\item{DASH_Score}{The calculated score (Range -2 to 4).}
\item{Risk_Category}{"Low Risk" (Score <= 1) or "High Risk" (Score >= 2).}
\item{Annual_Recurrence_Risk}{Estimated annual risk of VTE recurrence.}
}
\references{
Tosetto A, Iorio A, Marcucci M, et al. Predicting disease recurrence in patients with previous unprovoked venous thromboembolism: a proposed prediction score (DASH). J Thromb Haemost. 2012;10(6):1019-1025. doi:10.1111/j.1538-7836.2012.04735.x
}
\examples{

# Example 1: High Risk
# Male (+1), Age 45 (+1), Normal D-Dimer (0)
# Score = 2
dash_vte_recurrence_score(0, 45, "male")

# Example 2: Low Risk
# Female (0), Age 30 (+1), Hormone Use (-2), Normal D-Dimer (0)
# Score = -1
dash_vte_recurrence_score(0, 30, "female", 1)
}
