\name{ett_depth_tidal_volume}
\alias{ett_depth_tidal_volume}
\title{
Endotracheal Tube (ETT) Depth and Tidal Volume Calculator
}
\description{
Calculates the appropriate depth for endotracheal tube placement and target tidal volumes based on patient height and sex. It provides depth estimates using two methods: the Chula formula (Height/10 + 4) and the 3x Tube Size rule. It also calculates Predicted Body Weight (PBW) to determine lung-protective tidal volume ranges (6-8 mL/kg).
}
\usage{
ett_depth_tidal_volume(height_cm, sex, tube_size_mm)
}
\arguments{
  \item{height_cm}{
Numeric. Patient height in centimeters.
}
  \item{sex}{
String. Patient sex ("Male" or "Female"). Used for PBW calculation.
}
  \item{tube_size_mm}{
Numeric. Internal diameter of the endotracheal tube in millimeters (e.g., 7.5).
}
}
\value{
A list containing:
\item{Predicted_Body_Weight_kg}{Calculated PBW used for tidal volume dosing.}
\item{Tidal_Volume_Target_6_8_ml_kg}{Recommended tidal volume range (6-8 mL/kg PBW) for lung-protective ventilation.}
\item{ETT_Depth_Chula_cm}{Estimated depth of insertion from the Chula formula.}
\item{ETT_Depth_3x_Size_cm}{Estimated depth of insertion using the 3x tube size rule.}
}
\references{
Techanivate A, Kumwilaisak K, Samranrean S. Estimation of the proper length of orotracheal intubation by Chula formula. J Med Assoc Thai. 2005;88(12):1838-1846.
Acute Respiratory Distress Syndrome Network. Ventilation with lower tidal volumes as compared with traditional tidal volumes for acute lung injury and the acute respiratory distress syndrome. N Engl J Med. 2000;342(18):1301-1308. doi:10.1056/NEJM200005043421801
}
\examples{

# Example 1: Adult Male
# 180 cm, Male, 7.5 mm tube
# PBW = 50 + 0.91*(180-152.4) = ~75 kg
# TV = 450-600 mL
# Depth (Chula) = 18 + 4 = 22 cm
# Depth (3x) = 22.5 cm
ett_depth_tidal_volume(180, "male", 7.5)

# Example 2: Adult Female
# 160 cm, Female, 7.0 mm tube
# PBW = 45.5 + 0.91*(160-152.4) = ~52 kg
# TV = 312-416 mL
# Depth (Chula) = 16 + 4 = 20 cm
# Depth (3x) = 21 cm
ett_depth_tidal_volume(160, "female", 7.0)
}
