\name{garfield_af_risk_score}
\alias{garfield_af_risk_score}
\title{
GARFIELD-AF Risk Calculator
}
\description{
Structures the clinical inputs for the GARFIELD-AF Risk Calculator. This integrated risk tool estimates the 1-year and 2-year risks of all-cause mortality, stroke/systemic embolism, and major bleeding in patients with newly diagnosed atrial fibrillation. It accounts for demographics, vital signs, comorbidities, and antithrombotic treatment.
}
\usage{
garfield_af_risk_score(sex, age, weight_kg, heart_rate, systolic_bp,
                       chf_history, acs_history, history_stroke_tia,
                       history_bleeding, ckd_stage_3_to_5, diabetes,
                       treatment_type)
}
\arguments{
  \item{sex}{
String. Patient sex ("Male" or "Female").
}
  \item{age}{
Numeric. Patient age in years.
}
  \item{weight_kg}{
Numeric. Patient weight in kilograms.
}
  \item{heart_rate}{
Numeric. Heart rate in beats per minute.
}
  \item{systolic_bp}{
Numeric. Systolic blood pressure in mmHg.
}
  \item{chf_history}{
Numeric (0 or 1). History of Congestive Heart Failure. (1 = Yes).
}
  \item{acs_history}{
Numeric (0 or 1). History of Acute Coronary Syndrome. (1 = Yes).
}
  \item{history_stroke_tia}{
Numeric (0 or 1). History of Stroke, TIA, or Systemic Embolism. (1 = Yes).
}
  \item{history_bleeding}{
Numeric (0 or 1). History of bleeding. (1 = Yes).
}
  \item{ckd_stage_3_to_5}{
Numeric (0 or 1). Moderate to severe Chronic Kidney Disease (Stage 3-5). (1 = Yes).
}
  \item{diabetes}{
Numeric (0 or 1). Diabetes Mellitus. (1 = Yes).
}
  \item{treatment_type}{
String. Current antithrombotic treatment. Options: "none", "vka" (Vitamin K Antagonist), "doac" (Direct Oral Anticoagulant), "antiplatelet", "combination".
}
}
\value{
A list containing:
\item{Patient_Profile}{Summary of demographics and vitals.}
\item{Risk_Factors_Identified}{List of positive risk factors contributing to the score.}
\item{Note}{Guidance regarding the regression model used for the final percentage output.}
}
\references{
Fox KAA, Lucas JE, Pieper KS, et al. Improved risk stratification of patients with atrial fibrillation: an integrated GARFIELD-AF tool for the prediction of mortality, stroke and bleeding in patients with and without anticoagulation. BMJ Open. 2017;7(12):e017157. doi:10.1136/bmjopen-2017-017157
}
\examples{

# Example 1: Multiple Comorbidities
# 75yo Male, CHF, Prior Stroke, on VKA
garfield_af_risk_score("male", 75, 80, 72, 130, 1, 0, 1, 0, 0, 0, "vka")

# Example 2: Low Comorbidity
# 55yo Female, No history, on Antiplatelet
garfield_af_risk_score("female", 55, 60, 68, 120, 0, 0, 0, 0, 0, 0, "antiplatelet")
}
