\name{gmaws_score}
\alias{gmaws_score}
\title{
Glasgow Modified Alcohol Withdrawal Scale (GMAWS)
}
\description{
Calculates the GMAWS score, a 5-item scale used to assess the severity of alcohol withdrawal syndrome. Each item is scored from 0 to 2. This scale is widely used in the UK and other regions to guide symptom-triggered benzodiazepine therapy.
}
\usage{
gmaws_score(tremor, hallucinations, orientation, agitation, sweating)
}
\arguments{
  \item{tremor}{
Numeric (0-2).
0: No tremor.
1: Mild tremor.
2: Moderate/Severe tremor.
}
  \item{hallucinations}{
Numeric (0-2).
0: No hallucinations.
1: Mild hallucinations (distraction possible).
2: Severe hallucinations (continuous, no distraction possible).
}
  \item{orientation}{
Numeric (0-2).
0: Oriented to Time, Place, Person.
1: Oriented to 2 spheres.
2: Oriented to 1 or 0 spheres.
}
  \item{agitation}{
Numeric (0-2).
0: No agitation.
1: Mild agitation.
2: Moderate/Severe agitation (or aggression).
}
  \item{sweating}{
Numeric (0-2).
0: No sweating.
1: Moist palms / Mild sweat.
2: Drenching sweats.
}
}
\value{
A list containing:
\item{GMAWS_Score}{The calculated total score (Range 0-10).}
\item{Severity}{Clinical severity classification (Mild <4, Moderate 4-7, Severe >=8).}
\item{Management_Guidance}{General treatment recommendation based on the score threshold of 4.}
}
\references{
McPherson A, et al. A new scale for the assessment of alcohol withdrawal symptoms. 2004. (Standard guideline reference).
}
\examples{

# Example 1: Treatment Threshold Met
# Moderate tremor (2), Mild sweat (1), Agitation (1)
# Score = 4
gmaws_score(2, 0, 0, 1, 1)

# Example 2: Mild Withdrawal
# Mild tremor only
# Score = 1
gmaws_score(1, 0, 0, 0, 0)
}
