\name{grace_acs_risk}
\alias{grace_acs_risk}
\title{
GRACE ACS Risk and Mortality Calculator
}
\description{
Calculates the GRACE (Global Registry of Acute Coronary Events) Risk Score for predicting in-hospital mortality in patients with Acute Coronary Syndrome (ACS). The score stratifies patients based on age, heart rate, systolic blood pressure, creatinine, Killip class, cardiac arrest at admission, ST-segment deviation, and elevated cardiac enzymes.
}
\usage{
grace_acs_risk(age, heart_rate, systolic_bp, creatinine, killip_class,
               cardiac_arrest_admission, st_segment_deviation,
               elevated_cardiac_enzymes, creatinine_units = "mg/dL")
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
}
  \item{heart_rate}{
Numeric. Heart rate in beats per minute.
}
  \item{systolic_bp}{
Numeric. Systolic blood pressure in mmHg.
}
  \item{creatinine}{
Numeric. Serum creatinine level.
}
  \item{killip_class}{
Numeric (1-4). Killip Class classification for heart failure severity.
1: No signs of congestive heart failure.
2: Rales, S3 gallop, or JVD.
3: Frank pulmonary edema.
4: Cardiogenic shock.
}
  \item{cardiac_arrest_admission}{
Numeric (0 or 1). Cardiac arrest occurred at admission. (1 = Yes).
}
  \item{st_segment_deviation}{
Numeric (0 or 1). ST-segment deviation on EKG. (1 = Yes).
}
  \item{elevated_cardiac_enzymes}{
Numeric (0 or 1). Elevated cardiac enzymes/markers (e.g., Troponin). (1 = Yes).
}
  \item{creatinine_units}{
String. Units for creatinine input. Options: "mg/dL" (default) or "umol/L".
}
}
\value{
A list containing:
\item{GRACE_Score}{The calculated total risk score (Range 0-372).}
\item{In_Hospital_Mortality_Risk}{Estimated percentage probability of in-hospital death.}
\item{Risk_Category}{Classification (Low, Intermediate, High).}
}
\references{
Granger CB, Goldberg RJ, Dabbous O, et al. Predictors of hospital mortality in the global registry of acute coronary events. Arch Intern Med. 2003;163(19):2345-2353. doi:10.1001/archinte.163.19.2345
}
\examples{

# Example 1: High Risk
# 75yo, HR 110, SBP 100, Cr 2.0, Killip 3, ST Dev Yes, Enzymes Yes
# Score calculation depends on variable bins.
grace_acs_risk(75, 110, 100, 2.0, 3, 0, 1, 1)

# Example 2: Low Risk
# 50yo, HR 70, SBP 130, Cr 0.9, Killip 1, No arrest/ST dev/Enzymes
grace_acs_risk(50, 70, 130, 0.9, 1, 0, 0, 0)
}
