\name{grogan_attr_cm_staging}
\alias{grogan_attr_cm_staging}
\title{
Grogan (Mayo Clinic) Staging System for ATTR-CM
}
\description{
Calculates the Grogan Stage for patients with wild-type Transthyretin Amyloid Cardiomyopathy (ATTRwt-CM). The staging system predicts overall survival based on two biomarkers: NT-proBNP (threshold 3000 pg/mL) and Troponin T (threshold 0.05 ng/mL) or Troponin I (threshold 0.1 ng/mL).
}
\usage{
grogan_attr_cm_staging(nt_probnp_pg_ml, troponin_t_ng_ml = NULL,
                       troponin_i_ng_ml = NULL)
}
\arguments{
  \item{nt_probnp_pg_ml}{
Numeric. N-terminal pro-B-type Natriuretic Peptide level in pg/mL. (Threshold >= 3000 adds 1 point).
}
  \item{troponin_t_ng_ml}{
Numeric (Optional). Troponin T level in ng/mL. (Threshold >= 0.05 adds 1 point). Provide either TnT or TnI.
}
  \item{troponin_i_ng_ml}{
Numeric (Optional). Troponin I level in ng/mL. (Threshold >= 0.1 adds 1 point). Provide either TnT or TnI.
}
}
\value{
A list containing:
\item{Grogan_Stage}{The calculated stage (1, 2, or 3).}
\item{Median_Overall_Survival}{Estimated median survival based on the Mayo Clinic derivation cohort.}
}
\references{
Grogan M, Scott CG, Kyle RA, et al. Natural History of Wild-Type Transthyretin Cardiac Amyloidosis and Risk Stratification Using a Novel Staging System. J Am Coll Cardiol. 2016;68(10):1014-1020. doi:10.1016/j.jacc.2016.06.033
}
\examples{

# Example 1: Stage 1 (Low Risk)
# NT-proBNP 1500 (<3000), TnT 0.02 (<0.05)
grogan_attr_cm_staging(1500, troponin_t_ng_ml = 0.02)

# Example 2: Stage 3 (High Risk)
# NT-proBNP 5000 (>3000), TnI 0.2 (>0.1)
grogan_attr_cm_staging(5000, troponin_i_ng_ml = 0.2)
}
