\name{hope_score_hypothermia}
\alias{hope_score_hypothermia}
\title{
HOPE Score for Hypothermia Outcome Prediction
}
\description{
Calculates the HOPE score to estimate the probability of survival in patients with hypothermic cardiac arrest undergoing Extracorporeal Life Support (ECLS) rewarming. The score uses age, sex, hypothermia mechanism (asphyxia vs non-asphyxia), CPR duration, serum potassium, and core temperature.
}
\usage{
hope_score_hypothermia(age, sex, mechanism_hypothermia, cpr_duration_min,
                       potassium_mmol_l, temperature_c)
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
}
  \item{sex}{
String. Patient sex ("Male" or "Female").
}
  \item{mechanism_hypothermia}{
String. Mechanism of hypothermia. "asphyxia" (e.g., submersion, avalanche) or "non-asphyxia" (e.g., exposure). Non-asphyxia is a positive predictor.
}
  \item{cpr_duration_min}{
Numeric. Duration of cardiopulmonary resuscitation in minutes.
}
  \item{potassium_mmol_l}{
Numeric. Serum potassium level in mmol/L.
}
  \item{temperature_c}{
Numeric. Core body temperature in degrees Celsius.
}
}
\value{
A list containing:
\item{HOPE_Score_Probability}{The estimated percentage probability of survival to hospital discharge.}
\item{Recommendation}{Guidance on ECLS utility based on the calculated probability.}
}
\references{
Pasquier M, Hugli O, Paal P, et al. Hypothermia outcome prediction after extracorporeal life support for hypothermic cardiac arrest patients: The HOPE score. Resuscitation. 2018;126:58-64. doi:10.1016/j.resuscitation.2018.02.026
}
\examples{

# Example 1: Good Prognosis
# 30yo Male, Non-asphyxia (Exposure), CPR 60 min, K 4.0, Temp 28C
hope_score_hypothermia(30, "male", "non-asphyxia", 60, 4.0, 28)

# Example 2: Poor Prognosis
# 60yo Female, Asphyxia (Drowning), CPR 90 min, K 8.0, Temp 30C
hope_score_hypothermia(60, "female", "asphyxia", 90, 8.0, 30)
}
