\name{improvedd_vte_score}
\alias{improvedd_vte_score}
\title{
IMPROVEDD VTE Risk Score
}
\description{
Calculates the IMPROVEDD (IMPROVE + D-Dimer) VTE Risk Score. This tool enhances the original IMPROVE score by adding elevated D-dimer as a weighted risk factor, improving the identification of hospitalized medical patients at high risk for venous thromboembolism (VTE).
}
\usage{
improvedd_vte_score(previous_vte, known_thrombophilia, lower_limb_paralysis,
                    current_cancer, immobilized_ge_7days, icu_ccu_stay,
                    age_gt_60, d_dimer_ge_2x_uln)
}
\arguments{
  \item{previous_vte}{
Numeric (0 or 1). History of previous VTE. (1 = Yes, +3 points).
}
  \item{known_thrombophilia}{
Numeric (0 or 1). Known thrombophilia. (1 = Yes, +2 points).
}
  \item{lower_limb_paralysis}{
Numeric (0 or 1). Current lower-limb paralysis or paresis. (1 = Yes, +2 points).
}
  \item{current_cancer}{
Numeric (0 or 1). Active cancer. (1 = Yes, +2 points).
}
  \item{immobilized_ge_7days}{
Numeric (0 or 1). Immobilization >= 7 days. (1 = Yes, +1 point).
}
  \item{icu_ccu_stay}{
Numeric (0 or 1). Stay in ICU or CCU. (1 = Yes, +1 point).
}
  \item{age_gt_60}{
Numeric (0 or 1). Age > 60 years. (1 = Yes, +1 point).
}
  \item{d_dimer_ge_2x_uln}{
Numeric (0 or 1). D-dimer level >= 2 times the Upper Limit of Normal (ULN). (1 = Yes, +2 points).
}
}
\value{
A list containing:
\item{IMPROVEDD_Score}{The calculated score (Range 0-14).}
\item{Risk_Category}{Classification (Low 0-1, Moderate 2-3, High >=4).}
\item{VTE_Risk_42_Day}{Estimated 42-day VTE risk percentage.}
}
\references{
Gibson CM, Spyropoulos AC, Cohen AT, et al. The IMPROVEDD VTE Risk Score: A New Model for Predicting Venous Thromboembolism in Acutely Ill Hospitalized Medical Patients. TH Open. 2017;1(1):e56-e65. doi:10.1055/s-0037-1604432
}
\examples{

# Example 1: High Risk
# Prior VTE (+3), D-Dimer High (+2)
# Score = 5
improvedd_vte_score(1, 0, 0, 0, 0, 0, 0, 1)

# Example 2: Moderate Risk
# Age >60 (+1), Immobilized (+1)
# Score = 2
improvedd_vte_score(0, 0, 0, 0, 1, 0, 1, 0)
}
