\name{international_iga_nephropathy_prediction}
\alias{international_iga_nephropathy_prediction}
\title{
International IgA Nephropathy Prediction Tool
}
\description{
Calculates the linear predictor for the risk of disease progression (50\% decline in eGFR or ESRD) in patients with IgA Nephropathy at the time of biopsy. The model incorporates clinical data (eGFR, MAP, Proteinuria, Age, Race, Medications) and histologic findings (Oxford MEST score).
}
\usage{
international_iga_nephropathy_prediction(age_at_biopsy, egfr_at_biopsy,
                                         proteinuria_g_day, map_mmhg, race,
                                         mest_m, mest_e, mest_s, mest_t,
                                         use_rasb, use_immunosuppression)
}
\arguments{
  \item{age_at_biopsy}{
Numeric. Age in years at the time of biopsy.
}
  \item{egfr_at_biopsy}{
Numeric. eGFR (mL/min/1.73m^2) at the time of biopsy.
}
  \item{proteinuria_g_day}{
Numeric. Urine protein excretion (g/day).
}
  \item{map_mmhg}{
Numeric. Mean Arterial Pressure (mmHg).
}
  \item{race}{
String. Patient race: "white", "chinese", "japanese", "other".
}
  \item{mest_m}{
Numeric (0 or 1). Mesangial hypercellularity (M0/M1).
}
  \item{mest_e}{
Numeric (0 or 1). Endocapillary hypercellularity (E0/E1).
}
  \item{mest_s}{
Numeric (0 or 1). Segmental glomerulosclerosis (S0/S1).
}
  \item{mest_t}{
Numeric (0, 1, or 2). Tubular atrophy/interstitial fibrosis (T0/T1/T2).
}
  \item{use_rasb}{
Numeric (0 or 1). Use of Renin-Angiotensin System Blockers at/before biopsy. (1 = Yes).
}
  \item{use_immunosuppression}{
Numeric (0 or 1). Use of Immunosuppression at/before biopsy. (1 = Yes).
}
}
\value{
A list containing:
\item{Linear_Predictor}{The calculated linear risk score. Higher values indicate higher risk.}
}
\references{
Barbour SJ, Coppo R, Zhang H, et al. Evaluating a New International Risk-Prediction Tool in IgA Nephropathy. JAMA Intern Med. 2019;179(7):942-952. doi:10.1001/jamainternmed.2019.0600
}
\examples{

# Example 1: High Risk
# 30yo, eGFR 45, Protein 2.5g, MAP 105, M1 E1 S1 T2, No meds, White
international_iga_nephropathy_prediction(30, 45, 2.5, 105, "white", 1, 1, 1, 2, 0, 0)

# Example 2: Low Risk
# 40yo, eGFR 90, Protein 0.5g, MAP 90, M0 E0 S0 T0, RASB Yes, Chinese
international_iga_nephropathy_prediction(40, 90, 0.5, 90, "chinese", 0, 0, 0, 0, 1, 0)
}
