\name{irae_colitis_grading}
\alias{irae_colitis_grading}
\title{
irAE Grading for Colitis (GI Toxicities)
}
\description{
Calculates the CTCAE severity grade for colitis associated with immune checkpoint inhibitor (ICPi) therapy. Grading is based on the increase in stool frequency over baseline, presence of incontinence, severity of symptoms (pain, blood, mucus), and life-threatening complications (e.g., perforation).

[Image of bristol stool scale chart]

}
\usage{
irae_colitis_grading(stools_above_baseline, incontinence, life_threatening,
                     pain_mucus_blood)
}
\arguments{
  \item{stools_above_baseline}{
Numeric. Number of stools per day ABOVE the patient's baseline. (<4: Grade 1, 4-6: Grade 2, >=7: Grade 3).
}
  \item{incontinence}{
Numeric (0 or 1). New onset of incontinence? (1 = Yes). Presence indicates at least Grade 3.
}
  \item{life_threatening}{
Numeric (0 or 1). Are there life-threatening consequences (e.g., perforation, shock)? (1 = Yes). Indicates Grade 4.
}
  \item{pain_mucus_blood}{
Numeric (0 or 1). Presence of severe abdominal pain, mucus, or blood in stool? (1 = Yes). Often associated with Grade 3 severity in clinical context/guidelines if impacting ADL, though pure stool count is primary driver.
}
}
\value{
A list containing:
\item{CTCAE_Grade}{The calculated adverse event grade (1-4).}
\item{Definition}{Clinical description of the grade.}
\item{Management_Recommendation}{Guidance on ICPi continuation and immunosuppressive therapy based on ASCO guidelines.}
}
\references{
Brahmer JR, Lacchetti C, Schneider BJ, et al. Management of Immune-Related Adverse Events in Patients Treated With Immune Checkpoint Inhibitor Therapy: American Society of Clinical Oncology Clinical Practice Guideline. J Clin Oncol. 2018;36(17):1714-1768. doi:10.1200/JCO.2017.77.6385
}
\examples{

# Example 1: Grade 3 Colitis
# 8 stools over baseline, no life threatening signs
irae_colitis_grading(8, 0, 0, 0)

# Example 2: Grade 2 Colitis
# 5 stools over baseline
irae_colitis_grading(5, 0, 0, 0)
}
