\name{isee_eoe_severity_index}
\alias{isee_eoe_severity_index}
\title{
Index of Severity for Eosinophilic Esophagitis (I-SEE)
}
\description{
Calculates the I-SEE score to assess the severity of Eosinophilic Esophagitis (EoE). The score categorizes disease activity into Inactive, Mild, Moderate, or Severe based on symptoms, complications, and inflammatory/fibrostenotic features found on endoscopy and histology.
}
\usage{
isee_eoe_severity_index(symptoms_frequency,
food_impaction_code, hospitalization_eoe,
esophageal_perforation, malnutrition_code,
persistent_inflammation,
 endoscopic_inflammatory_grade,
 peak_eosinophil_count_grade,
 endoscopic_fibrostenotic_grade,
 histologic_fibrostenotic_grade)
}
\arguments{
  \item{symptoms_frequency}{
Numeric. Frequency of symptoms (Dysphagia, Pain, etc.).
0: None.
1: Weekly.
2: Daily.
3: Multiple times per day or disrupting social functioning.
}
  \item{food_impaction_code}{
Numeric. History of food impaction requiring ER visit or endoscopy.
0: None.
1: Food impaction in adult (>=18 years).
2: Food impaction in child (<18 years).
}
  \item{hospitalization_eoe}{
Numeric (0 or 1). Hospitalization due to EoE (excluding planned elective procedures). (1 = Yes, +4 points).
}
  \item{esophageal_perforation}{
Numeric (0 or 1). History of esophageal perforation. (1 = Yes, +15 points).
}
  \item{malnutrition_code}{
Numeric (0 or 1). Malnutrition (BMI <5th percentile or decreased growth trajectory). (1 = Yes, +15 points).
}
  \item{persistent_inflammation}{
Numeric (0 or 1). Persistent inflammation requiring elemental formula, systemic steroids, or biologics. (1 = Yes, +15 points).
}
  \item{endoscopic_inflammatory_grade}{
Numeric. Endoscopic inflammatory features (Edema, Furrows, Exudates).
0: None.
1: Localized.
2: Diffuse.
}
  \item{peak_eosinophil_count_grade}{
Numeric. Peak Eosinophil Count (eos/hpf).
0: < 15.
1: 15-60.
2: > 60.
}
  \item{endoscopic_fibrostenotic_grade}{
Numeric. Endoscopic fibrostenotic features (Rings, Strictures).
0: None.
1: Present, endoscope passes easily.
2: Present, requires dilation or snug fit.
3: Cannot pass standard scope, repeated dilations (adult), or any dilation (child). (+15 points).
}
  \item{histologic_fibrostenotic_grade}{
Numeric (0 or 1). Histologic fibrostenotic features (Basal zone hyperplasia, lamina propria fibrosis). (1 = Yes, +2 points).
}
}
\value{
A list containing:
\item{ISEE_Score}{The calculated total severity score.}
\item{Severity}{Classification (Inactive <1, Mild 1-6, Moderate 7-14, Severe >=15).}
}
\references{
Dellon ES, Khoury P, Muir AB, et al. A Clinical Severity Index for Eosinophilic Esophagitis: Development, Consensus, and Future Directions. Gastroenterology. 2022;163(1):59-76. doi:10.1053/j.gastro.2022.03.025
}
\examples{

# Example 1: Moderate EoE
# Daily symptoms(2), Localized inflam(1), Eos 40(1), BZH(2)
# Score = 2 + 1 + 1 + 2 = 6 (Wait, 6 is Mild? Check logic. Mild 1-6. So Mild/Moderate border.)
isee_eoe_severity_index(2, 0, 0, 0, 0, 0, 1, 1, 0, 1)

# Example 2: Severe EoE
# Stricture requiring dilation (+15), Daily Sx (+2)
# Score = 17
isee_eoe_severity_index(2, 0, 0, 0, 0, 0, 1, 1, 3, 0)
}
