\name{menza_hiv_risk_score}
\alias{menza_hiv_risk_score}
\title{
Menza Score for HIV Risk in MSM
}
\description{
Calculates the Menza Score to predict the 4-year risk of HIV infection in Men who have Sex with Men (MSM). The score identifies high-risk individuals who may benefit from targeted prevention strategies such as Pre-Exposure Prophylaxis (PrEP).
}
\usage{
menza_hiv_risk_score(history_sti, drug_use_meth_poppers,
                     unprotected_anal_intercourse, partners_gt_10)
}
\arguments{
  \item{history_sti}{
Numeric (0 or 1). Current or history of gonorrhea, chlamydia, or syphilis. (1 = Yes, +4 points).
}
  \item{drug_use_meth_poppers}{
Numeric (0 or 1). Use of methamphetamine or inhaled nitrites (poppers) in the prior 6 months. (1 = Yes, +11 points).
}
  \item{unprotected_anal_intercourse}{
Numeric (0 or 1). Unprotected anal intercourse with a partner of positive or unknown HIV status in the prior year. (1 = Yes, +1 point).
}
  \item{partners_gt_10}{
Numeric (0 or 1). Report of 10 or more male sexual partners in the prior year. (1 = Yes, +3 points).
}
}
\value{
A list containing:
\item{Menza_Score}{The calculated risk score.}
\item{Risk_Category}{Classification (High Risk >= 1, Low Risk 0).}
\item{Recommendation}{Clinical guidance regarding prevention strategies.}
}
\references{
Menza TW, et al.  Prediction of HIV acquisition among men who have sex with men. Sex Transm Dis. 2009;36(9):547-555. doi:10.1097/OLQ.0b013e3181a7d10b
}
\examples{

# Example 1: High Risk
# History of STI (+4), no other factors
# Score = 4
menza_hiv_risk_score(1, 0, 0, 0)

# Example 2: Low Risk
# No risk factors present
# Score = 0
menza_hiv_risk_score(0, 0, 0, 0)
}
