\name{modified_bishop_score}
\alias{modified_bishop_score}
\title{
Modified Bishop Score for Vaginal Delivery
}
\description{
Calculates the Modified Bishop Score to assess the readiness of the cervix for induction of labor. The score evaluates five parameters: Dilation, Effacement, Station, Consistency, and Position. A higher score indicates a more favorable cervix for successful vaginal delivery.
}
\usage{
modified_bishop_score(dilation_cm, effacement_percent, station,
                      consistency, position)
}
\arguments{
  \item{dilation_cm}{
Numeric. Cervical dilation in centimeters.
0 cm: 0 pts.
1-2 cm: 1 pt.
3-4 cm: 2 pts.
>= 5 cm: 3 pts.
}
  \item{effacement_percent}{
Numeric. Cervical effacement percentage.
0-30\%: 0 pts.
40-50\%: 1 pt.
60-70\%: 2 pts.
>= 80\%: 3 pts.
}
  \item{station}{
Numeric. Fetal station relative to ischial spines (-3 to +2).
-3: 0 pts.
-2: 1 pt.
-1, 0: 2 pts.
+1, +2: 3 pts.
}
  \item{consistency}{
String. Consistency of the cervix. Options: "firm" (0 pts), "medium" (1 pt), "soft" (2 pts).
}
  \item{position}{
String. Position of the cervix. Options: "posterior" (0 pts), "midposition" (1 pt), "anterior" (2 pts).
}
}
\value{
A list containing:
\item{Bishop_Score}{The calculated total score (Range 0-13).}
\item{Interpretation}{Clinical assessment (Favorable > 8, Unfavorable < 6).}
}
\references{
Laughon SK, Zhang J, Troendle J, Sun L, Reddy UM. Using a simplified Bishop score to predict vaginal delivery. Obstet Gynecol. 2011;117(4):805-811. doi:10.1097/AOG.0b013e3182114ad2
}
\examples{

# Example 1: Favorable Cervix
# 4cm dilated (2), 60\% effaced (2), -1 station (2), Soft (2), Anterior (2)
# Score = 10
modified_bishop_score(4, 60, -1, "soft", "anterior")

# Example 2: Unfavorable Cervix
# Closed (0), 30\% effaced (0), -3 station (0), Firm (0), Posterior (0)
# Score = 0
modified_bishop_score(0, 30, -3, "firm", "posterior")
}
