\name{osteoporosis_self_assessment_tool}
\alias{osteoporosis_self_assessment_tool}
\title{
Osteoporosis Self-Assessment Tool (OST) for Women
}
\description{
Calculates the OST score to stratify the risk of osteoporosis in postmenopausal women using only age and weight. The tool was originally developed for Asian populations but has been validated in other cohorts to help select women for Bone Mineral Density (BMD) testing.
}
\usage{
osteoporosis_self_assessment_tool(age, weight_kg)
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
}
  \item{weight_kg}{
Numeric. Patient weight in kilograms.
}
}
\value{
A list containing:
\item{OST_Score}{The calculated score (truncated integer).}
\item{Risk_Category}{Classification (Low >1, Moderate -3 to 1, High < -3).}
\item{Recommendation}{Guidance regarding BMD testing.}
}
\references{
Koh LK, Sedrani O, Lim SE, et al. A simple tool to identify Asian women at increased risk of osteoporosis. Osteoporos Int. 2001;12(8):699-705. doi:10.1007/s001980170070
}
\examples{

# Example 1: High Risk
# 75yo, 45kg -> (45-75)*0.2 = -6
osteoporosis_self_assessment_tool(75, 45)

# Example 2: Low Risk
# 55yo, 70kg -> (70-55)*0.2 = 3
osteoporosis_self_assessment_tool(55, 70)
}
