\name{ottawa_copd_risk_scale}
\alias{ottawa_copd_risk_scale}
\title{
Ottawa COPD Risk Scale
}
\description{
Calculates the Ottawa COPD Risk Scale score to predict the risk of short-term serious adverse events (SAEs) in patients presenting to the Emergency Department with acute exacerbation of COPD. SAEs include death, intubation, non-invasive ventilation, MI, or readmission.
}
\usage{
ottawa_copd_risk_scale(history_copd, history_intubation, history_revascularization,
                       sa02_on_arrival, ecg_ischemia, antianginal_medication,
                       heart_rate_on_arrival, cxr_pulmonary_venous_congestion,
                       hemoglobin_on_arrival, bun_on_arrival)
}
\arguments{
  \item{history_copd}{
Numeric (0 or 1). Validated only for patients with COPD.
}
  \item{history_intubation}{
Numeric (0 or 1). History of intubation for respiratory distress. (1 = Yes, +2 pts).
}
  \item{history_revascularization}{
Numeric (0 or 1). History of coronary revascularization (CABG/PCI). (1 = Yes, +1 pt).
}
  \item{sa02_on_arrival}{
Numeric. Initial oxygen saturation on arrival (\%). (< 92\% adds 2 pts).
}
  \item{ecg_ischemia}{
Numeric (0 or 1). Evidence of acute ischemia on ECG. (1 = Yes, +2 pts).
}
  \item{antianginal_medication}{
Numeric (0 or 1). Use of antianginal medication (e.g., nitroglycerin). (1 = Yes, +1 pt).
}
  \item{heart_rate_on_arrival}{
Numeric. Initial heart rate (bpm). (>= 110 bpm adds 2 pts).
}
  \item{cxr_pulmonary_venous_congestion}{
Numeric (0 or 1). Pulmonary venous congestion on Chest X-ray. (1 = Yes, +2 pts).
}
  \item{hemoglobin_on_arrival}{
Numeric. Hemoglobin level on arrival (g/L). (< 100 g/L adds 3 pts).
}
  \item{bun_on_arrival}{
Numeric. Urea (BUN) level on arrival (mmol/L). (> 12 mmol/L adds 1 pt).
}
}
\value{
A list containing:
\item{Ottawa_COPD_Risk_Score}{The calculated total score (Range 0-16).}
\item{Risk_Short_Term_Adverse_Event}{Estimated percentage probability of an adverse event within 30 days.}
}
\references{
Stiell IG, Clement CM, Aaron SD, et al. Clinical characteristics associated with adverse events in patients with exacerbation of chronic obstructive pulmonary disease: a prospective cohort study. CMAJ. 2014;186(6):E193-204. doi:10.1503/cmaj.130968
}
\examples{

# Example 1: High Risk
# Prior intubation (+2), Low SaO2 (+2), Tachycardia (+2), Low Hb (+3)
# Score = 9
ottawa_copd_risk_scale(1, 1, 0, 88, 0, 0, 120, 0, 90, 5)

# Example 2: Low Risk
# Only high BUN (+1)
# Score = 1
ottawa_copd_risk_scale(1, 0, 0, 95, 0, 0, 80, 0, 140, 15)
}
