\name{rome_iv_opioid_induced_constipation}
\alias{rome_iv_opioid_induced_constipation}
\title{
Rome IV Diagnostic Criteria for Opioid-Induced Constipation (OIC)
}
\description{
Evaluates the Rome IV criteria for diagnosing Opioid-Induced Constipation (OIC) in adults. Diagnosis requires chronic opioid use, new or worsened constipation symptoms (meeting functional constipation criteria) following the initiation of opioids, and the absence of sufficient criteria for Irritable Bowel Syndrome (IBS).
}
\usage{
rome_iv_opioid_induced_constipation(opioid_use_ge_3mo, symptom_onset_after_opioid,
                                    straining_ge_25_percent,
                                    lumpy_hard_stool_ge_25_percent,
                                    sensation_incomplete_evacuation_ge_25_percent,
                                    sensation_anorectal_blockage_ge_25_percent,
                                    manual_maneuver_ge_25_percent, lt_3_sbm_per_week,
                                    insufficient_criteria_for_ibs)
}
\arguments{
  \item{opioid_use_ge_3mo}{
Numeric (0 or 1). Chronic opioid use (at least 3 months). (1 = Yes).
}
  \item{symptom_onset_after_opioid}{
Numeric (0 or 1). New or worsening symptoms of constipation or onset after initiating opioids. (1 = Yes).
}
  \item{straining_ge_25_percent}{
Numeric (0 or 1). Straining during at least 25\% of defecations. (1 = Yes).
}
  \item{lumpy_hard_stool_ge_25_percent}{
Numeric (0 or 1). Lumpy or hard stools (BSFS 1 or 2) in at least 25\% of defecations

[Image of bristol stool scale chart]
. (1 = Yes).
}
  \item{sensation_incomplete_evacuation_ge_25_percent}{
Numeric (0 or 1). Sensation of incomplete evacuation in at least 25\% of defecations. (1 = Yes).
}
  \item{sensation_anorectal_blockage_ge_25_percent}{
Numeric (0 or 1). Sensation of anorectal obstruction/blockage in at least 25\% of defecations. (1 = Yes).
}
  \item{manual_maneuver_ge_25_percent}{
Numeric (0 or 1). Use of manual maneuvers to facilitate at least 25\% of defecations. (1 = Yes).
}
  \item{lt_3_sbm_per_week}{
Numeric (0 or 1). Less than 3 spontaneous bowel movements (SBM) per week. (1 = Yes).
}
  \item{insufficient_criteria_for_ibs}{
Numeric (0 or 1). Do criteria for Irritable Bowel Syndrome (IBS) fail to be met? (1 = Yes). This is a required exclusion.
}
}
\value{
A list containing:
\item{Diagnosis}{"Criteria Met for Opioid-Induced Constipation (OIC)" or "Criteria Not Met".}
\item{Constipation_Criteria_Count}{The number of positive constipation symptoms (Q3-Q8).}
}
\references{
Lacy BE, Mearin F, Chang L, et al. Bowel Disorders. Gastroenterology. 2016;150:1393-1407. doi:10.1053/j.gastro.2016.02.031
}
\examples{

# Example 1: Diagnosis Met
# Opioid use (1), Symptoms worsened (1),
#Three constipation criteria met (e.g. straining, hard stool, lt 3 SBM)
rome_iv_opioid_induced_constipation(1, 1, 1, 1, 0, 0, 0, 1, 1)

# Example 2: Not Met (Insufficient Constipation Symptoms)
# Only one symptom met (straining).
rome_iv_opioid_induced_constipation(1, 1, 1, 0, 0, 0, 0, 0, 1)
}
