\name{rome_iv_proctalgia_fugax}
\alias{rome_iv_proctalgia_fugax}
\title{
Rome IV Diagnostic Criteria for Proctalgia Fugax
}
\description{
Evaluates the Rome IV criteria for diagnosing Proctalgia Fugax, a functional anorectal pain disorder characterized by recurrent, short-lived episodes of severe pain in the rectum.
}
\usage{
rome_iv_proctalgia_fugax(recurrent_severe_pain, duration_lt_30min,
                         frequency_lt_5_year, organic_causes_excluded,
                         symptom_onset_ge_6mo, symptoms_active_3mo)
}
\arguments{
  \item{recurrent_severe_pain}{
Numeric (0 or 1). Presence of recurrent episodes of severe pain localized to the rectum. (1 = Yes).
}
  \item{duration_lt_30min}{
Numeric (0 or 1). Do episodes last seconds to minutes (less than 30 minutes)? (1 = Yes).
}
  \item{frequency_lt_5_year}{
Numeric (0 or 1). Are episodes infrequent (less than 5 times per year)? (1 = Yes).
}
  \item{organic_causes_excluded}{
Numeric (0 or 1). Are symptoms NOT better explained by structural/organic pathology (e.g., hemorrhoids, IBD)? (1 = Yes).
}
  \item{symptom_onset_ge_6mo}{
Numeric (0 or 1). Did symptom onset occur at least 6 months prior to diagnosis? (1 = Yes).
}
  \item{symptoms_active_3mo}{
Numeric (0 or 1). Have symptoms been active for the last 3 months? (1 = Yes).
}
}
\value{
A list containing:
\item{Diagnosis}{"Criteria Met for Proctalgia Fugax" or "Criteria Not Met".}
}
\references{
Rao SS, Bharucha AE, Chiarioni G, et al. Anorectal Disorders. Gastroenterology. 2016;150:1430-1442. doi:10.1053/j.gastro.2016.02.009
}
\examples{

# Example 1: Diagnosis Met
# Recurrent pain (1), Duration minutes (1),
#Frequency 3/year (1), Organic excluded (1), Chronic met (1,1)
rome_iv_proctalgia_fugax(1, 1, 1, 1, 1, 1)

# Example 2: Not Met (Frequency too high)
# Recurrent pain, Duration minutes, Frequency 6/year (0 for < 5)
rome_iv_proctalgia_fugax(1, 1, 0, 1, 1, 1)
}
