\name{safe_fibrosis_score}
\alias{safe_fibrosis_score}
\title{
Steatosis-Associated Fibrosis Estimator (SAFE) Score
}
\description{
Calculates the SAFE score to predict the presence of significant liver fibrosis (stage F2 or higher) in patients with Non-Alcoholic Fatty Liver Disease (NAFLD) / Metabolic Dysfunction-Associated Steatotic Liver Disease (MASLD). The score uses age, BMI, diabetes status, platelet count, AST/ALT ratio, and serum globulin.
}
\usage{
safe_fibrosis_score(age, bmi, diabetes, platelets, alt, ast, globulin)
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
}
  \item{bmi}{
Numeric. Body Mass Index in kg/m^2.
}
  \item{diabetes}{
Numeric (0 or 1). Presence of Type 2 Diabetes Mellitus. (1 = Yes).
}
  \item{platelets}{
Numeric. Platelet count in x10^9/L.
}
  \item{alt}{
Numeric. Alanine Aminotransferase level in U/L.
}
  \item{ast}{
Numeric. Aspartate Aminotransferase level in U/L.
}
  \item{globulin}{
Numeric. Serum Globulin level in g/dL. (Can be calculated as Total Protein - Albumin).
}
}
\details{
The regression formula used is:
\deqn{SAFE = -4.782 + (0.037 \times Age) + (0.094 \times BMI) + (1.13 \times Diabetes) + (0.99 \times \frac{AST}{ALT}) - (0.013 \times Platelets) + (0.66 \times Globulin)}
A score > 0 indicates a high risk of significant fibrosis (>= F2).
}
\value{
A list containing:
\item{SAFE_Score}{The calculated logit score.}
\item{Probability}{The estimated probability of significant fibrosis.}
\item{Interpretation}{Risk classification based on the 0 cutoff.}
}
\references{
Alkhouri N, et al. The Steatosis-Associated Fibrosis Estimator (SAFE) Score: A Novel Score to Detect Significant Fibrosis in Patients with Non-Alcoholic Fatty Liver Disease. 2018.
}
\examples{

# Example 1: High Risk
# Age 50, BMI 35, Diabetes Yes, Plt 150, ALT 40, AST 50 (Ratio 1.25), Globulin 3.5
safe_fibrosis_score(50, 35, 1, 150, 40, 50, 3.5)

# Example 2: Low Risk
# Age 30, BMI 25, No Diabetes, Plt 250, ALT 30, AST 20 (Ratio 0.67), Globulin 2.5
safe_fibrosis_score(30, 25, 0, 250, 30, 20, 2.5)
}
