\name{sins_spine_score}
\alias{sins_spine_score}
\title{
Spinal Instability Neoplastic Score (SINS)
}
\description{
Calculates the SINS score to assess spinal stability in patients with spinal neoplastic disease. The scale helps guide referrals to spinal surgeons by categorizing lesions as stable, indeterminate, or unstable based on six radiographic and clinical factors.
}
\usage{
sins_spine_score(location, pain_type, bone_lesion_type, spinal_alignment,
                 vertebral_collapse, posterior_involvement)
}
\arguments{
  \item{location}{
String. Location of the lesion.
"junctional": Occiput-C2, C7-T2, T11-L1, L5-S1 (3 pts).
"mobile": C3-C6, L2-L4 (2 pts).
"semirigid": T3-T10 (1 pt).
"rigid": S2-S5 (0 pts).
}
  \item{pain_type}{
String. Assessment of pain.
"mechanical": Pain with movement/upright, relieved by recumbency (3 pts).
"occasional_non_mechanical": Pain not clearly mechanical (1 pt).
"pain_free": No pain (0 pts).
}
  \item{bone_lesion_type}{
String. Radiographic appearance of the bone lesion.
"lytic" (2 pts).
"mixed": Lytic/Blastic (1 pt).
"blastic" (0 pts).
}
  \item{spinal_alignment}{
String. Radiographic spinal alignment.
"subluxation_translation": Present (4 pts).
"de_novo_deformity": Kyphosis or scoliosis (2 pts).
"normal" (0 pts).
}
  \item{vertebral_collapse}{
String. Degree of vertebral body collapse.
"gt_50_percent": >50\% collapse (3 pts).
"lt_50_percent": <50\% collapse (2 pts).
"no_collapse_gt_50_involved": No collapse but >50\% body involvement (1 pt).
"none": None of the above (0 pts).
}
  \item{posterior_involvement}{
String. Involvement of posterolateral elements (pedicles, facets, spinous processes).
"bilateral" (3 pts).
"unilateral" (1 pt).
"none" (0 pts).
}
}
\value{
A list containing:
\item{SINS_Score}{The calculated total score (Range 0-18).}
\item{Stability_Classification}{Classification (Stable 0-6, Indeterminate 7-12, Unstable 13-18).}
\item{Recommendation}{Clinical guidance on surgical consultation.}
}
\references{
Fisher CG, DiPaola CP, Ryken TC, et al. A novel classification system for spinal instability in neoplastic disease: an evidence-based approach and expert consensus from the Spine Oncology Study Group. Spine. 2010;35(22):E1221-1229. doi:10.1097/BRS.0b013e3181e16ae2
}
\examples{

# Example 1: Unstable
# Junctional (3), Mechanical Pain (3), Lytic (2),
#Subluxation (4), >50% Collapse (3), Bilateral Posterior (3)
# Score = 18
sins_spine_score("junctional", "mechanical", "lytic",
"subluxation_translation", "gt_50_percent", "bilateral")

# Example 2: Stable
# Rigid (0), Pain Free (0), Blastic (0), Normal (0), None (0), None (0)
# Score = 0
sins_spine_score("rigid", "pain_free", "blastic", "normal", "none", "none")
}
