\name{six_minute_walk_prediction}
\alias{six_minute_walk_prediction}
\title{
6-Minute Walk Distance (6MWD) Reference Equations
}
\description{
Calculates the predicted 6-Minute Walk Distance (6MWD) and the Lower Limit of Normal (LLN) for healthy adults based on the reference equations by Enright and Sherrill (1998). If the patient's actual walked distance is provided, it calculates the percent predicted and evaluates if the performance is below the LLN.
}
\usage{
six_minute_walk_prediction(sex, age, height_cm, weight_kg, actual_distance_m = NULL)
}
\arguments{
  \item{sex}{
String. Patient sex ("Male" or "Female").
}
  \item{age}{
Numeric. Patient age in years (Range 40-80 years in validation study, but applicable to adults).
}
  \item{height_cm}{
Numeric. Patient height in centimeters.
}
  \item{weight_kg}{
Numeric. Patient weight in kilograms.
}
  \item{actual_distance_m}{
Numeric (Optional). The actual distance walked by the patient in meters. If provided, the function returns \% Predicted and an interpretation relative to the LLN.
}
}
\value{
A list containing:
\item{Predicted_Distance_m}{The estimated distance a healthy individual of the same demographics should walk.}
\item{Lower_Limit_Normal_m}{The threshold below which the distance is considered abnormal (5th percentile).}
\item{Percent_Predicted}{Ratio of Actual to Predicted distance (if actual is provided).}
\item{Interpretation}{"Below Lower Limit of Normal" or "Normal" (if actual is provided).}
}
\references{
Enright PL, Sherrill DL. Reference equations for the six-minute walk in healthy adults. Am J Respir Crit Care Med. 1998;158(5 Pt 1):1384-1387. doi:10.1164/ajrccm.158.5.9710086
}
\examples{

# Example 1: Prediction only
# 65yo Male, 175cm, 80kg
six_minute_walk_prediction("male", 65, 175, 80)

# Example 2: With Actual Distance
# 60yo Female, 160cm, 70kg, walked 400 meters
six_minute_walk_prediction("female", 60, 160, 70, actual_distance_m = 400)
}
