\name{tdn_neurology_grade}
\alias{tdn_neurology_grade}
\title{
Therapy-Disability-Neurology (TDN) Grade
}
\description{
Calculates the TDN Grade for grading the severity of adverse events (AEs) in neurosurgery. Unlike therapy-based classifications (e.g., Clavien-Dindo), the TDN grade incorporates three dimensions: the Therapy used to treat the AE, the resulting Disability (based on the modified Rankin Scale), and the presence of new Neurologic deficits. The final grade is determined by the highest severity across these three domains.
}
\usage{
tdn_neurology_grade(therapy_level, disability_mrs, new_neurologic_deficit)
}
\arguments{
  \item{therapy_level}{
String. The therapy required to manage the adverse event.
"none_bedside": Allowed modalities only (antiemetics, antipyretics, analgesics, diuretics, electrolytes, bedside wound opening). (T1).
"pharmacologic": Pharmacological treatment (e.g., antibiotics), blood transfusion, or TPN. (T2).
"invasive": Surgical, endoscopic, or radiological intervention. (T3).
"icu_life_threatening": Life-threatening complication requiring ICU management. (T4).
"death": Resulting in death. (T5).
}
  \item{disability_mrs}{
Numeric. The patient's modified Rankin Scale (mRS) score describing functional status/disability associated with the AE.
0-1: No significant disability (D1).
2-3: Slight to moderate disability (hinders at least one ADL) (D2).
4: Moderately severe disability (unable to walk/attend bodily needs without assistance) (D3).
5: Severe disability (bedridden, incontinent, constant nursing care) (D4).
6: Death (D5).
}
  \item{new_neurologic_deficit}{
Numeric (0 or 1). Did the adverse event result in a new neurological deficit? (1 = Yes [N2], 0 = No [N1]).
}
}
\value{
A list containing:
\item{TDN_Grade}{The calculated severity grade (1-5).}
\item{Definition}{Clinical description of the grade.}
\item{Inputs}{The individual scores (T, D, N) contributing to the final grade.}
}
\references{
Terrapon APR, Zattra CM, Voglis S, et al. Adverse Events in Neurosurgery: The Novel Therapy-Disability-Neurology Grade. Neurosurgery. 2021;89(2):236-245. doi:10.1093/neuros/nyab121
}
\examples{

# Example 1: Grade 2 (New deficit, but no major therapy or severe disability)
# Therapy: Bedside (T1), mRS 1 (D1), New Neuro Deficit (N2) -> Max(1,1,2) = 2
tdn_neurology_grade("none_bedside", 1, 1)

# Example 2: Grade 3 (Invasive therapy required)
# Therapy: Surgical repair (T3), mRS 2 (D2), New Neuro Deficit (N2) -> Max(3,2,2) = 3
tdn_neurology_grade("invasive", 2, 1)

# Example 3: Grade 4 (Severe disability)
# Therapy: Pharmacologic (T2), mRS 5 (D4), New Neuro Deficit (N2) -> Max(2,4,2) = 4
tdn_neurology_grade("pharmacologic", 5, 1)
}
