\name{therapeutic_plasmapheresis}
\alias{therapeutic_plasmapheresis}
\title{
Therapeutic Plasmapheresis (Plasma Exchange) Calculator
}
\description{
Calculates the estimated Total Blood Volume (TBV), Estimated Plasma Volume (EPV), and the total volume of plasma to be removed/exchanged based on patient weight, hematocrit, and the desired number of plasma volumes to exchange.
}
\usage{
therapeutic_plasmapheresis(weight_kg, hematocrit_percent, exchange_volume_pv = 1.0)
}
\arguments{
  \item{weight_kg}{
Numeric. Patient weight in kilograms.
}
  \item{hematocrit_percent}{
Numeric. Patient's hematocrit as a percentage (0-100).
}
  \item{exchange_volume_pv}{
Numeric. The target number of plasma volumes to exchange (e.g., 1.0, 1.2, 1.5). Defaults to 1.0.
}
}
\details{
The calculations use the following standard estimations (Gilcher's rule of thumb):
\deqn{TBV (mL) = Weight (kg) \times 70 mL/kg}
\deqn{EPV (mL) = TBV \times (1 - Hct)}
\deqn{Exchange Volume (mL) = EPV \times Target PV}
Note: 70 mL/kg is a standard estimate for adults; actual blood volume may vary based on body composition and demographics.
}
\value{
A list containing:
\item{Total_Blood_Volume_mL}{Estimated Total Blood Volume.}
\item{Estimated_Plasma_Volume_mL}{Estimated total plasma volume of the patient.}
\item{Volume_to_Exchange_mL}{The volume of plasma to be removed/exchanged to meet the target.}
}
\references{
Kaplan AA. Therapeutic plasma exchange: A technical overview. J Clin Apher. 2013;28(1):3-10.
}
\examples{

# Example 1: Standard 1.0 PV exchange
# 70kg patient, Hct 40%
# TBV = 4900, EPV = 4900 * 0.6 = 2940 mL
therapeutic_plasmapheresis(70, 40, 1.0)

# Example 2: 1.5 PV exchange for TTP
# 80kg patient, Hct 30%
# TBV = 5600, EPV = 5600 * 0.7 = 3920 mL
# Exchange = 3920 * 1.5 = 5880 mL
therapeutic_plasmapheresis(80, 30, 1.5)
}
