\name{urine_output_calculator}
\alias{urine_output_calculator}
\title{
Urine Output Calculator
}
\description{
Calculates urine output normalized by patient weight and time (mL/kg/hr). This metric is critical for assessing renal perfusion, fluid balance, and identifying oliguria or acute kidney injury.
}
\usage{
urine_output_calculator(urine_volume_ml, time_hours, weight_kg)
}
\arguments{
  \item{urine_volume_ml}{
Numeric. Total volume of urine produced in milliliters.
}
  \item{time_hours}{
Numeric. Duration of collection in hours.
}
  \item{weight_kg}{
Numeric. Patient weight in kilograms.
}
}
\details{
The formula is:
\deqn{Output (mL/kg/hr) = \frac{Total Volume (mL)}{Time (hr) \times Weight (kg)}}
Standard thresholds for oliguria:
- Adults: < 0.5 mL/kg/hr
- Children: < 1.0 mL/kg/hr
- Infants: < 2.0 mL/kg/hr
}
\value{
A list containing:
\item{Urine_Output_mL_kg_hr}{The normalized urine output.}
\item{Hourly_Rate_mL_hr}{The average hourly urine production.}
\item{Interpretation_Adult}{Classification based on the adult threshold of 0.5 mL/kg/hr.}
}
\references{
Kellum JA, Lameire N, KDIGO AKI Guideline Work Group. Diagnosis, evaluation, and management of acute kidney injury: a KDIGO summary (Part 1). Crit Care. 2013;17(1):204. doi:10.1186/cc11454
}
\examples{

# Example 1: Oliguria
# 200 mL over 6 hours, 80 kg
# Rate = 200/6 = 33.3 mL/hr. Normalized = 33.3/80 = 0.42 mL/kg/hr
urine_output_calculator(200, 6, 80)

# Example 2: Adequate Output
# 1000 mL over 12 hours, 70 kg
# Rate = 83.3 mL/hr. Normalized = 1.19 mL/kg/hr
urine_output_calculator(1000, 12, 70)
}
