% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abbreviateStatements.R
\name{abbreviateStatements}
\alias{abbreviateStatements}
\title{Abbreviate Statements in Concept Map Data}
\usage{
abbreviateStatements(CMData, max_length = 30)
}
\arguments{
\item{CMData}{A data frame containing concept map data. The data should have at least the following column:
\itemize{
\item \code{statement}: The text of the statement to be abbreviated.
}}

\item{max_length}{An integer specifying the maximum number of characters for the abbreviated statement. Default is 30.}
}
\value{
A data frame with the same structure as the input, but with an updated "statement" column containing the
abbreviated statements.
}
\description{
This function processes the "statement" column of a data frame containing concept map data by converting each
statement to lowercase, removing stopwords, and truncating the statement to a specified maximum length.
It allows for the abbreviation of long statements while maintaining their core meaning by removing unnecessary words.
}
\details{
This function performs several preprocessing steps on the "statement" column:
\itemize{
\item Converts statements to lowercase.
\item Removes punctuation and stopwords from the statements.
\item Truncates statements to a specified maximum length.
\item Removes any rows with empty statements after processing.
}

Stopwords are predefined and include common English words (e.g., "the", "and", "is", "a", etc.) that do not contribute
much meaning to the core idea of the statement.
}
\examples{
# Create a sample data frame with concept map data
conceptMapData <- data.frame(
   id = c(1, 2, 3),
    statement = c(
       "The quick brown fox jumps over the lazy dog",
       "This is a simple concept map example",
       "Data science involves analyzing datasets"
    )
)

# Apply the abbreviateStatements function with a maximum length of 20
result <- abbreviateStatements(conceptMapData, max_length = 20)

print(result)

}
