#' Time Series of Gold Particle Counts in a Well-Defined Colloidal Solution
#'
#' A sample of 370 counts of gold particles in a well-defined colloidal
#' solution at equidistant points in time. The data were originally 
#' published in Westgren (1916) and later used in Jung and Tremayne (2006).
#'
#' @source Jung, R.C.; Tremayne, A.R. (2006) 
#'   Coherent forecasting in integer time series models. 
#'   \emph{International Journal of Forecasting}, \bold{22}, 223--238.
#'
#'   Westgren, A. (1916) Die Veraenderungsgeschwindigkeit der lokalen 
#'   Teilchenkonzentration in kolloidalen Systemen (Erste Mitteilung). 
#'   \emph{Arkiv foer Matematik, Astronomi och Fysik}, \bold{11}, 1--24.
#'
#' @format A time series (`ts`) object containing 370 observations at equidistant time points.
#' @keywords datasets
#' @examples
#' plot(goldparticle)
"goldparticle"
