% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codestral_init.R
\name{codestral_init}
\alias{codestral_init}
\title{Initialize codestral}
\usage{
codestral_init(
  mistral_apikey = Sys.getenv(x = "R_MISTRAL_APIKEY"),
  codestral_apikey = Sys.getenv(x = "R_CODESTRAL_APIKEY"),
  fim_model = "codestral-latest",
  chat_model = "codestral-latest",
  mamba_model = "open-codestral-mamba",
  temperature = 0,
  max_tokens_FIM = 100,
  max_tokens_chat = "",
  role_content = NULL
)
}
\arguments{
\item{mistral_apikey, codestral_apikey}{The API keys to use for accessing
Codestral Mamba and Codestral. Default to the value of the
\code{R_MISTRAL_APIKEY}, \code{R_CODESTRAL_APIKEY} environment variable. Note that
the name of the variable \code{mistra_apikey} is purposely not mentionning
Codestra Mamba because this key can be use for other Mistral AI models
(except Codestral).}

\item{fim_model}{A string giving the model to use for FIM.}

\item{chat_model}{A string giving the model to use for Codestral chat.}

\item{mamba_model}{A string giving the model to use for Codestral Mamba chat.}

\item{temperature}{An integer giving the temperature to use.}

\item{max_tokens_FIM, max_tokens_chat}{Integers giving the maximum
number of tokens to generate for each of these operations.}

\item{role_content}{A role to assign to the system Default is "You write
programs in R language only. You adopt a proper coding approach by strictly
naming all the functions' parameters when calling any function with named
parameters even when calling nested functions, by being straighforward in
your answers."}
}
\value{
Invisible \code{0}.
}
\description{
Create environment variables for operationg FIM and chat.
}
\details{
The most important paremeters here are the \code{..._apikey} parameters
without which the Mistral AI API can not be used.

To start with, beginners may keep default values for other parameters. It
seems sound to use the latest models of each type. However with time, the
user may be willing to customize \code{temperature}, \code{max_tokens_FIM}, \code{max_tokens_chat} and
\code{role_content} for his/her own needs.
}
