% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{draw.MCMCrings}
\alias{draw.MCMCrings}
\title{plot the dates and model of a MCMC wiggle-match dated tree}
\usage{
draw.MCMCrings(
  yrs,
  dR,
  dat,
  cc,
  Us,
  delta.R,
  delta.STD,
  BCAD,
  cal.lim = c(),
  cal.lab = c(),
  C14.lim = c(),
  C14.lab = c(),
  mar = c(3, 3, 1, 1),
  mgp = c(1.7, 0.7, 0),
  main.height = 0.55,
  dist.height = 0.5,
  name = c(),
  name.loc = "topleft",
  MCMC.col = grey(0.3),
  prior.col = "green",
  prior.lab = "delta.R",
  text.col = "red",
  post.col = rgb(0, 0, 0, 0.3),
  cc.col = rgb(0, 0, 1, 0.5),
  dets.col = "black",
  adj.col = grey(0.5)
)
}
\arguments{
\item{yrs}{The modelled years.}

\item{dR}{The modelled delta.R values.}

\item{dat}{The data, extracted from the .csv file.}

\item{cc}{Calibration curve to be used. Could be 1 (IntCal20; default), 2 (Marine20), 3 (SHCal20) or 4 (custom curve).}

\item{Us}{Energy of the MCMC run (for the topleft graph).}

\item{delta.R}{Prior for the mean delta.R.}

\item{delta.STD}{Prior for the standard deviation of delta.R.}

\item{BCAD}{The calendar scale of graphs and age output-files is in \code{cal BP} by default, but can be changed to BC/AD using \code{BCAD=TRUE}.}

\item{cal.lim}{The limits for the bottom calendar axis. Calculated automatically by default.}

\item{cal.lab}{The labels for the bottom calendar axis (default \code{age.lab="cal BP"} or \code{"BC/AD"}.}

\item{C14.lim}{The limits for the bottom C14 axis. Calculated automatically by default.}

\item{C14.lab}{The labels for the bottom y-axis. Defaults to 14C BP with superscript 14, so \code{expression(""^14*C~BP)}.}

\item{mar}{Axis margins. Defaults to \code{mar=c(3, 3, 1, 1)}.}

\item{mgp}{Axis text margins (where should titles, labels and tick marks be plotted). Defaults to \code{mgp=c(1.7, .7, .0)}.}

\item{main.height}{Height of the main panel, relative to the top panels. Defaults to 0.55.}

\item{dist.height}{Height of the age distribution, relative to the vertical axis extent. Defaults to 0.5.}

\item{name}{Name to plot in the main panel.}

\item{name.loc}{Location of the name, defaults to \code{name.loc="topleft"}.}

\item{MCMC.col}{Colour of the MCMC run. Defaults to dark grey, \code{MCMC.col=grey(0.3)}.}

\item{prior.col}{Colour of the prior for the delta.R distribution, default green.}

\item{prior.lab}{Label of the prior. Defaults to "delta.R".}

\item{text.col}{Colour of the text describing the delta.R prior. Defaults to red.}

\item{post.col}{Colour of the posterior distributions. Defaults to semi-transparent dark grey.}

\item{cc.col}{Colour of the calibration curve. Defaults to semi-transparent blue, \code{dist.col=rgb(0,0,1,0.5)}.}

\item{dets.col}{Colour of the radiocarbon determinations ranges. Defaults to \code{"black"} but could also give colours for each individual, date, e.g., \code{dets.col=1:10}.}

\item{adj.col}{Colour of the adjusted C14 dates. Defaults to grey.}
}
\value{
A plot with the MCMC run, the prior and posterior for deltaR, and the posterior age estimate together with the placements of the radiocarbon dates.
}
\description{
A plot with three panels. The top panels show the MCMC run (left) and the prior (gren) and posterior (grey) distributions for deltaR, the age offset (assumed to be constant among all C14 ages). The main panel shows the age distribution of the inner ring, and also the placements of the radiocarbon dates on the calibration curve taking the best (mode) calendar age. Grey dots show the placements of the dates with the modelled age offset.
}
\author{
Maarten Blaauw, Marco Aquino Lopez
}
