% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reporting.R
\name{reportggstatsplotPostHoc}
\alias{reportggstatsplotPostHoc}
\title{Report significant post-hoc pairwise comparisons}
\usage{
reportggstatsplotPostHoc(
  data,
  p,
  iv = "testiv",
  dv = "testdv",
  label_mappings = NULL
)
}
\arguments{
\item{data}{A data frame containing the raw data used to generate the plot.}

\item{p}{A \code{ggstatsplot} object (e.g., returned by \code{ggbetweenstats}) containing the pairwise comparison statistics.}

\item{iv}{Character string. The column name of the independent variable (grouping variable).}

\item{dv}{Character string. The column name of the dependent variable.}

\item{label_mappings}{Optional named list or vector. Used to rename factor levels in the output text
(e.g., \code{list("old_name" = "New Label")}).}
}
\value{
No return value. The function prints LaTeX-formatted text to the console.
}
\description{
This function extracts significant pairwise comparisons from a \code{ggstatsplot} object,
calculates the mean and standard deviation for the groups involved using the raw data,
and prints LaTeX-formatted sentences reporting the results.
}
\section{LaTeX Requirements}{

To easily copy and paste the results to your manuscript, the following commands
(or similar) must be defined in your LaTeX preamble, as the function outputs
commands taking arguments (e.g., \verb{\\m\{value\}}):

\preformatted{
  \newcommand{\m}[1]{\\textit{M}=#1}
  \newcommand{\sd}[1]{\\textit{SD}=#1}
  \newcommand{\padj}[1]{$p_{adj}=#1$}
  \newcommand{\padjminor}[1]{$p_{adj}<#1$}
}
}

\examples{
\donttest{
library(ggstatsplot)
library(dplyr)

# Generate a plot
plt <- ggbetweenstats(mtcars, am, mpg)

# Report stats
reportggstatsplotPostHoc(
  data = mtcars,
  p = plt,
  iv = "am",
  dv = "mpg",
  label_mappings = list("0" = "Automatic", "1" = "Manual")
)
}
}
