% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score_auc.R
\name{score_auc}
\alias{score_auc}
\title{Compute area under the ROC curve between binomial observations and probabilistic predictions}
\usage{
score_auc(o = NULL, p = NULL, ...)
}
\arguments{
\item{o}{(required, numeric vector) Binomial observations (values 0 and 1). Default: NULL}

\item{p}{(required, numeric vector) Prediction of binomial model in the range 0-1. Default: NULL}

\item{...}{(optional) Internal args (e.g. \code{function_name} for
\code{\link{validate_arg_function_name}}, a precomputed correlation matrix
\code{m}, or cross-validation args for \code{\link{preference_order}}).}
}
\value{
numeric: Area Under the ROC Curve
}
\description{
Internal function to compute the AUC of binomial models within \code{\link[=preference_order]{preference_order()}}. Used within \code{\link[=f_binomial_glm]{f_binomial_glm()}}, \code{\link[=f_binomial_gam]{f_binomial_gam()}}, and \code{\link[=f_binomial_rf]{f_binomial_rf()}}. This function is build for speed and it does not check the inputs.
}
\examples{
  score_auc(
    o = c(1, 1, 1, 1, 0, 0, 0),
    p = c(1, 0.8, 0.7, 0.6, 0.5, 0.6, 0.7)
  )

}
\seealso{
Other modelling_tools: 
\code{\link{case_weights}()},
\code{\link{model_formula}()},
\code{\link{score_cramer}()},
\code{\link{score_r2}()}
}
\concept{modelling_tools}
