% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_make.R
\name{extract_make}
\alias{extract_make}
\title{Turn a 'cmd_assign' Call Into a Makefile Rule}
\usage{
extract_make(path_file, dir_make = NULL)
}
\arguments{
\item{path_file}{A path from
\code{dir_make} to the R scripe containing
the call to \code{\link[=cmd_assign]{cmd_assign()}}.}

\item{dir_make}{The directory that contains
the Makefile. The default is
the current working directory.}
}
\value{
\code{extract_make()} is typically called
for its side effect, which is to print a
Makefile rule. However, \code{extract_make()}
invisibly returns a text string with the rule.
}
\description{
Extract a call to \code{\link[=cmd_assign]{cmd_assign()}} from an
R script, and turn it into a Makefile rule.
}
\section{The components of a Makefile rule}{
A Makefile rule produced by \code{extract_make()}
normally looks something like this:

\if{html}{\out{<div class="sourceCode">}}\preformatted{out/model.rds: src/model.R \\
  data/cleaned.rds
       Rscript $^ $@ --use_log=TRUE
}\if{html}{\out{</div>}}

In this rule
\itemize{
\item \code{out/model.rds} is the "target", i.e. the file that the rule creates;
\item \code{src/model.R} and \code{data/timeseries.rds} are "prerequisites",
i.e. files that are used to create the target;
\item \verb{\\} is a "line continuation character";
\item \verb{        } at the start of the third line is a tab,
telling \code{make} that the recipe for creating the target from
the starts here;
\item \code{Rscript} is a call to \code{\link[utils:Rscript]{utils::Rscript()}};
\item \verb{$^} is an \href{https://www.gnu.org/software/make/manual/make.html#Automatic-Variables}{automatic variable}
meaning "all the prerequisites"
and \verb{$@} is an automatic variable meaning "the target",
so that \verb{Rscript $^ $@} expands to
\verb{Rscript src/model.R data/cleaned.rds out/model.rds}; and
\item \code{--use_log=TRUE} is a named argument that
Rscript passes to \code{src/model.R}
}
}

\section{Using \code{extract_make()} to build a data analysis workflow}{
\itemize{
\item Step 1. Write the R file that carries out
the step in analysis (eg tidying data, fitting
a model, making a graph.) This file
will contain a call to \code{\link[=cmd_assign]{cmd_assign()}},
and  will appear in the first line of the
Makefile rule. When writing and testing the file,
use \code{\link[=cmd_assign]{cmd_assign()}} interactively.
\item Step 2. Once the R file is working correctly,
call \code{extract_make()}, and add the rule
to your Makefile.
}

When using \code{extract_make()}, it is a good idea to
set the current working directory to the project
directory (something that will happen automatically
if you are using RStudio projects.)
}

\section{Location of the Makefile}{
The Makefile normally sets at the top of
the project, so that the
project folder looks something like this:

\if{html}{\out{<div class="sourceCode">}}\preformatted{Makefile
- data/
- src/
- out/
report.qmd
}\if{html}{\out{</div>}}
}

\section{Identifying file arguments}{
To construct the Makefile rule, \code{extract_make()} needs to
be able to pick out arguments that refer to
file names. To do so, it uses the following heuristic:
\itemize{
\item if the call includes arguments whose names start with
a dot, then these arguments are assumed to
refer to file names;
\item otherwise, find arguments whose values
actually are file names
(as determined by \code{\link[=file.exists]{file.exists()}}), or that look
like they could be.
}
}

\examples{
library(fs)
library(withr)
with_tempdir({

  ## create 'src'  directory
  dir_create("src")

  ## put an R script containing a call to
  ## 'cmd_assign' in the 'src' directory
  writeLines(c("cmd_assign(x = 1, .out = 'out/results.rds')",
               "results <- x + 1",
               "saveRDS(results, file = .out)"),
             con = "src/results.R")

  ## call 'extract_make()'
  extract_make(path_file = "src/results.R",
               dir_make = ".")

})
}
\references{
\itemize{
\item \href{https://jeroenjanssens.com/dsatcl/chapter-6-project-management-with-make}{Project Management with Make}
Makefiles in data analysis workflows
\item \href{https://www.gnu.org/software/make/manual/make.html#SEC_Contents}{GNU make}
Definitive guide
\item \href{https://swcarpentry.github.io/r-novice-inflammation/05-cmdline.html}{Command-Line Programs}
Introduction to Rscript
}
}
\seealso{
\itemize{
\item \code{\link[=extract_shell]{extract_shell()}} Shell script equivalent of \code{extract_make()}
\item \code{\link[=makefile]{makefile()}} Create a Makefile
from calls to \code{\link[=cmd_assign]{cmd_assign()}}
\item \code{\link[=cmd_assign]{cmd_assign()}} Process command line arguments
\item \href{https://bayesiandemography.github.io/command/articles/quickstart.html}{Quick Start}
How to use \code{cmd_assign()}
\item \href{https://bayesiandemography.github.io/command/articles/workflow.html}{Modular Workflows for Data Analysis}
Safe, flexible data analysis workflows
\item \href{https://CRAN.R-project.org/package=littler}{littler} Alternative to Rscript
}
}
